/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BBOX3D;
import org.geotools.api.geometry.BoundingBox3D;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class BBOX3DImplTest {
    @Test
    public void testBbox3D() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        SimpleFeatureType type = null;
        try {
            type = DataUtilities.createType((String)"testSchema", (String)"name:String,*geom:Geometry");
        }
        catch (SchemaException e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature1", gf.createPoint(new Coordinate(10.0, 20.0, 30.0))}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"testFeature2", gf.createPoint(new Coordinate(10.0, 10.0, 60.0))}, null);
        ReferencedEnvelope3D envelope1 = new ReferencedEnvelope3D(0.0, 50.0, 0.0, 50.0, 0.0, 50.0, null);
        BBOX3D bbox1 = ff.bbox((Expression)ff.property("geom"), (BoundingBox3D)envelope1);
        ReferencedEnvelope3D envelope2 = new ReferencedEnvelope3D(0.0, 50.0, 0.0, 50.0, 50.0, 100.0, null);
        BBOX3D bbox2 = ff.bbox((Expression)ff.property("geom"), (BoundingBox3D)envelope2);
        Assert.assertTrue((boolean)bbox1.evaluate((Object)f1));
        Assert.assertFalse((boolean)bbox1.evaluate((Object)f2));
        Assert.assertFalse((boolean)bbox2.evaluate((Object)f1));
        Assert.assertTrue((boolean)bbox2.evaluate((Object)f2));
    }
}

