/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Literal;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LiteralExpressionImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class LiteralTest {
    FilterFactory ff;

    @Before
    public void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    @Test
    public void testValidConstruction() throws Exception {
        new LiteralExpressionImpl((Object)10.0);
        new LiteralExpressionImpl("Label");
        new LiteralExpressionImpl((Object)10);
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        new LiteralExpressionImpl((Object)gf.createGeometryCollection(null));
    }

    @Test
    public void testConversion() throws Exception {
        Assert.assertEquals((Object)"abc", (Object)this.ff.literal((Object)"abc").evaluate(null));
        Assert.assertEquals((Object)12, (Object)this.ff.literal((Object)"12").evaluate(null, Integer.class));
        Assert.assertEquals((Object)12.0, (Object)this.ff.literal((Object)"12.0").evaluate(null, Double.class));
        Assert.assertEquals((Object)12.5, (Object)this.ff.literal((Object)"12.5").evaluate(null, Double.class));
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)this.ff.literal((Object)"9223372036854775807").evaluate(null, Long.class));
        BigInteger doubleMaxLong = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
        Assert.assertEquals((Object)doubleMaxLong, (Object)this.ff.literal((Object)doubleMaxLong.toString()).evaluate(null, BigInteger.class));
    }

    @Test
    public void testDateEquality() throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.set(2012, 6, 15);
        Date d1 = cal.getTime();
        cal.set(2012, 8, 15);
        Date d2 = cal.getTime();
        Date d3 = cal.getTime();
        Literal l1 = this.ff.literal((Object)d1);
        Literal l2 = this.ff.literal((Object)d2);
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Literal l3 = this.ff.literal((Object)d3);
        Assert.assertEquals((Object)l2, (Object)l3);
    }
}

