/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import org.easymock.EasyMock;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.visitor.UniqueVisitor;
import org.junit.Test;

public class DecoratingFeatureCollectionTest {
    @Test
    public void testDelegateVisitor() throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        UniqueVisitor visitor = new UniqueVisitor(new Expression[]{ff.property("test")});
        FeatureCollection mock = (FeatureCollection)EasyMock.createMock(FeatureCollection.class);
        mock.accepts((FeatureVisitor)visitor, null);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mock});
        DecoratingFeatureCollection<FeatureType, Feature> decorator = new DecoratingFeatureCollection<FeatureType, Feature>(mock){

            protected boolean canDelegate(FeatureVisitor visitor) {
                return true;
            }
        };
        decorator.accepts((FeatureVisitor)visitor, null);
        EasyMock.verify((Object[])new Object[]{mock});
    }

    @Test
    public void testDontDelegateVisitor() throws IOException {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        UniqueVisitor visitor = new UniqueVisitor(new Expression[]{ff.property("test")});
        FeatureCollection mock = (FeatureCollection)EasyMock.createMock(FeatureCollection.class);
        FeatureIterator iterator = (FeatureIterator)EasyMock.createNiceMock(FeatureIterator.class);
        EasyMock.expect((Object)mock.features()).andReturn((Object)iterator);
        EasyMock.replay((Object[])new Object[]{mock, iterator});
        DecoratingFeatureCollection<FeatureType, Feature> decorator = new DecoratingFeatureCollection<FeatureType, Feature>(mock){

            protected boolean canDelegate(FeatureVisitor visitor) {
                return false;
            }
        };
        decorator.accepts((FeatureVisitor)visitor, null);
        EasyMock.verify((Object[])new Object[]{mock});
    }
}

