/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.FilteredIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;

public class MemoryFeatureCollectionTest
extends DataTestCase {
    private MemoryFeatureCollection roads;

    public void init() throws Exception {
        super.init();
        this.roads = new MemoryFeatureCollection(this.roadType);
        this.roads.addAll(Arrays.asList(this.roadFeatures));
    }

    @Test
    public void testAdd() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        for (SimpleFeature riverFeature : this.riverFeatures) {
            rivers.add(riverFeature);
        }
        Assert.assertEquals((long)this.riverFeatures.length, (long)rivers.size());
    }

    @Test
    public void testAddAll() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        rivers.addAll(Arrays.asList(this.riverFeatures));
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)this.roadFeatures.length, (long)this.roads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResources() {
        Object[] array = this.roads.toArray();
        Assert.assertEquals((long)this.roads.size(), (long)array.length);
        try (SimpleFeatureIterator i = this.roads.features();){
            Assert.assertTrue((boolean)i.hasNext());
        }
        try {
            Assert.assertFalse((boolean)i.hasNext());
            Assert.fail((String)"should be closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        i = this.roads.features();
        try {
            Assert.assertTrue((boolean)i.hasNext());
        }
        finally {
            i.close();
        }
        try {
            Assert.assertFalse((boolean)i.hasNext());
            Assert.fail((String)"should be closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testBounds() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        ReferencedEnvelope expected = new ReferencedEnvelope();
        for (SimpleFeature riverFeature : this.riverFeatures) {
            rivers.add(riverFeature);
            expected.include(riverFeature.getBounds());
        }
        Assert.assertEquals((long)this.riverFeatures.length, (long)rivers.size());
        Assert.assertNotNull((Object)rivers.getBounds());
        Assert.assertEquals((Object)expected, (Object)rivers.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIterator() throws Exception {
        int count = 0;
        Iterator it = this.roads.iterator();
        try {
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                ++count;
            }
        }
        finally {
            DataUtilities.close((Iterator)it);
        }
        Assert.assertEquals((long)this.roads.size(), (long)count);
        count = 0;
        try (FilteredIterator filteredIterator = new FilteredIterator((Collection)this.roads, this.rd12Filter);){
            while (filteredIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)filteredIterator.next();
                ++count;
            }
        }
        Assert.assertEquals((long)this.expected(this.rd12Filter), (long)count);
    }

    @Test
    public void testSubCollection() {
        int count = 0;
        try (SimpleFeatureIterator it = this.roads.features();){
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                if (!this.rd12Filter.evaluate((Object)feature)) continue;
                ++count;
            }
        }
        SimpleFeatureCollection sub = this.roads.subCollection(this.rd12Filter);
        Assert.assertEquals((long)count, (long)sub.size());
    }

    @Test
    public void testSubSubCollection() {
        SimpleFeatureCollection sub = this.roads.subCollection(this.rd12Filter);
        SimpleFeatureCollection subsub = sub.subCollection(this.rd1Filter);
        Assert.assertEquals((long)1L, (long)subsub.size());
    }

    public void XtestSort() {
    }
}

