/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;

public class DataStoreFinderTest {
    private static final Logger LOGGER = Logging.getLogger(DataStoreFinderTest.class);

    @Test
    public void testLookup() throws Exception {
        Iterator it = DataStoreFinder.getAvailableDataStores();
        Assert.assertTrue((boolean)it.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicRegistration() throws Exception {
        Map<String, String> params = Map.of("testKey", "testValue");
        DataStoreFactorySpi mockFactory = (DataStoreFactorySpi)EasyMock.createMock(DataStoreFactorySpi.class);
        EasyMock.expect((Object)mockFactory.isAvailable()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)mockFactory.canProcess(params)).andReturn((Object)true).anyTimes();
        DataStore mockStore = (DataStore)EasyMock.createMock(DataStore.class);
        EasyMock.expect((Object)mockFactory.createDataStore(params)).andReturn((Object)mockStore).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockFactory});
        Assert.assertNull((Object)DataStoreFinder.getDataStore(params));
        DataStoreFinder.registerFactory((DataStoreFactorySpi)mockFactory);
        try {
            Assert.assertEquals((Object)mockStore, (Object)DataStoreFinder.getDataStore(params));
        }
        finally {
            DataStoreFinder.deregisterFactory((DataStoreFactorySpi)mockFactory);
        }
        Assert.assertNull((Object)DataStoreFinder.getDataStore(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataAccessDeadlock() throws Exception {
        SlowFactory slowFactory = new SlowFactory();
        CountDownLatch latch = new CountDownLatch(2);
        Runnable t1 = () -> {
            try {
                DataAccessFinder.getDataStore(new HashMap());
                latch.countDown();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error calling DataAccessFinder.getDataStore", e);
            }
        };
        Runnable t2 = () -> {
            try {
                DataStoreFinder.getDataStore(new HashMap());
                latch.countDown();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error calling DataStoreFinder.getDataStore", e);
            }
        };
        ExecutorService es = Executors.newFixedThreadPool(3);
        try {
            DataAccessFinder.registerFactory((DataAccessFactory)slowFactory);
            try {
                DataStoreFinder.registerFactory((DataStoreFactorySpi)slowFactory);
                try {
                    Future<?> f1 = es.submit(t1);
                    slowFactory.waitForIsAvailable();
                    Future<?> f2 = es.submit(t2);
                    Thread.sleep(1000L);
                    slowFactory.allowIsAvailable();
                    slowFactory.waitForIsAvailable();
                    slowFactory.allowIsAvailable();
                    slowFactory.waitForIsAvailable();
                    slowFactory.allowIsAvailable();
                    f1.get(10L, TimeUnit.SECONDS);
                    f2.get(10L, TimeUnit.SECONDS);
                }
                finally {
                    DataStoreFinder.deregisterFactory((DataStoreFactorySpi)slowFactory);
                }
            }
            finally {
                DataAccessFinder.deregisterFactory((DataAccessFactory)slowFactory);
            }
        }
        finally {
            es.shutdownNow();
        }
        boolean success = latch.await(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)success);
    }

    static class SlowFactory
    implements DataStoreFactorySpi {
        private final LinkedBlockingQueue<Boolean> isAvailableGate = new LinkedBlockingQueue();
        private final SynchronousQueue<Boolean> isAvailableNotifier = new SynchronousQueue();

        SlowFactory() {
        }

        public void allowIsAvailable() {
            LOGGER.finest("allow isAvailable " + Thread.currentThread().getId());
            this.isAvailableGate.offer(false);
        }

        public void waitForIsAvailable() {
            LOGGER.finest("wait for isAvailable " + Thread.currentThread().getId());
            try {
                this.isAvailableNotifier.poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted in waitForIsAvailable", e);
            }
        }

        public DataStore createDataStore(Map<String, ?> params) {
            return null;
        }

        public String getDisplayName() {
            return "";
        }

        public String getDescription() {
            return "";
        }

        public DataAccessFactory.Param[] getParametersInfo() {
            return new DataAccessFactory.Param[0];
        }

        public boolean isAvailable() {
            LOGGER.log(Level.FINEST, "call isAvailable " + Thread.currentThread().getId(), new Exception());
            try {
                this.isAvailableNotifier.offer(false, 10L, TimeUnit.SECONDS);
                this.isAvailableGate.poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Interrupted in isAvailable", e);
            }
            return false;
        }

        public DataStore createNewDataStore(Map<String, ?> params) {
            return null;
        }
    }
}

