/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Collection;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultClockTime;
import org.geotools.temporal.reference.DefaultClock;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.temporal.Clock;
import org.opengis.temporal.ClockTime;
import org.opengis.temporal.IndeterminateValue;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultClockTest {
    private Clock clock1;
    private Clock clock2;

    @Before
    public void setUp() {
        NamedIdentifier name1 = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        NamedIdentifier name2 = new NamedIdentifier(Citations.CRS, "Julian calendar");
        DefaultTemporalReferenceSystem frame1 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name1, null);
        DefaultTemporalReferenceSystem frame2 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name2, null);
        Number[] clockTime1 = new Number[]{0, 0, 0};
        Number[] clockTime2 = new Number[]{12, 0, 0.0};
        DefaultClockTime clocktime1 = new DefaultClockTime((TemporalReferenceSystem)frame1, null, clockTime1);
        DefaultClockTime clocktime2 = new DefaultClockTime((TemporalReferenceSystem)frame2, null, clockTime2);
        DefaultClockTime utcReference1 = new DefaultClockTime((TemporalReferenceSystem)frame1, null, clockTime1);
        DefaultClockTime utcReference2 = new DefaultClockTime((TemporalReferenceSystem)frame2, null, clockTime2);
        this.clock1 = new DefaultClock((ReferenceIdentifier)name1, null, (InternationalString)new SimpleInternationalString("reference event"), (ClockTime)clocktime1, (ClockTime)utcReference1);
        this.clock2 = new DefaultClock((ReferenceIdentifier)name2, null, (InternationalString)new SimpleInternationalString("description"), (ClockTime)clocktime2, (ClockTime)utcReference2);
    }

    @After
    public void tearDown() {
        this.clock1 = null;
        this.clock2 = null;
    }

    @Test
    public void testGetReferenceEvent() {
        InternationalString result = this.clock1.getReferenceEvent();
        Assert.assertFalse((boolean)this.clock2.getReferenceEvent().equals(result));
    }

    @Test
    public void testGetReferenceTime() {
        ClockTime result = this.clock1.getReferenceTime();
        Assert.assertFalse((boolean)this.clock2.getReferenceTime().equals(result));
    }

    @Test
    public void testGetUTCReference() {
        ClockTime result = this.clock1.getUTCReference();
        Assert.assertFalse((boolean)this.clock2.getUTCReference().equals(result));
    }

    @Test
    public void testClkTrans() {
    }

    @Test
    public void testUtcTrans() {
    }

    @Test
    public void testSetReferenceEvent() {
        InternationalString result = this.clock1.getReferenceEvent();
        ((DefaultClock)this.clock1).setReferenceEvent((InternationalString)new SimpleInternationalString(""));
        Assert.assertFalse((boolean)this.clock1.getReferenceEvent().equals(result));
    }

    @Test
    public void testSetReferenceTime() {
        ClockTime result = this.clock1.getReferenceTime();
        ((DefaultClock)this.clock1).setReferenceTime((ClockTime)new DefaultClockTime((TemporalReferenceSystem)this.clock1, IndeterminateValue.UNKNOWN, null));
        Assert.assertFalse((boolean)this.clock1.getReferenceTime().equals(result));
    }

    @Test
    public void testSetUtcReference() {
        ClockTime result = this.clock1.getUTCReference();
        ((DefaultClock)this.clock1).setUtcReference((ClockTime)new DefaultClockTime((TemporalReferenceSystem)this.clock1, IndeterminateValue.UNKNOWN, null));
        Assert.assertFalse((boolean)this.clock1.getUTCReference().equals(result));
    }

    @Test
    public void testGetDateBasis() {
        Collection result = ((DefaultClock)this.clock1).getDateBasis();
        Assert.assertEquals((Object)((DefaultClock)this.clock2).getDateBasis(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.clock1.equals(null));
        Assert.assertEquals((Object)this.clock1, (Object)this.clock1);
        Assert.assertFalse((boolean)this.clock1.equals(this.clock2));
    }

    @Test
    public void testHashCode() {
        int result = this.clock1.hashCode();
        Assert.assertFalse((this.clock2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.clock1.toString();
        Assert.assertFalse((boolean)this.clock2.toString().equals(result));
    }
}

