/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.temporal.Position;
import org.opengis.temporal.TemporalPosition;
import org.opengis.util.InternationalString;

public class DefaultPositionTest {
    private Position position1;
    private Position position2;

    @Before
    public void setUp() {
        Calendar cal = Calendar.getInstance();
        cal.set(1981, 6, 25);
        this.position1 = new DefaultPosition(cal.getTime());
        cal.set(2012, 0, 1);
        this.position2 = new DefaultPosition(cal.getTime());
    }

    @After
    public void tearDown() {
        this.position1 = null;
        this.position2 = null;
    }

    @Test
    public void testAnyOther() {
        TemporalPosition result = this.position1.anyOther();
        Assert.assertEquals((Object)this.position2.anyOther(), (Object)result);
    }

    @Test
    public void testGetDate() {
        Date result = this.position1.getDate();
        Assert.assertFalse((boolean)this.position2.getDate().equals(result));
    }

    @Test
    public void testGetTime() {
        Time result = this.position1.getTime();
        Assert.assertEquals((Object)this.position2.getTime(), (Object)result);
    }

    @Test
    public void testGetDateTime() {
        InternationalString result = this.position1.getDateTime();
        Assert.assertFalse((boolean)this.position2.getDateTime().equals(result));
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.position1.equals(null));
        Assert.assertEquals((Object)this.position1, (Object)this.position1);
        Assert.assertFalse((boolean)this.position1.equals(this.position2));
    }

    @Test
    public void testHashCode() {
        int result = this.position1.hashCode();
        Assert.assertFalse((this.position2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.position1.toString();
        Assert.assertFalse((boolean)this.position2.toString().equals(result));
    }
}

