/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Calendar;
import java.util.Date;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.Position;

public class DefaultPeriodTest {
    private Period period1;
    private Period period2;

    @Before
    public void setUp() {
        Calendar cal = Calendar.getInstance();
        cal.set(1995, 1, 1);
        DefaultInstant begining1 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        cal.set(2000, 1, 1);
        DefaultInstant ending1 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        cal.set(2000, 1, 1);
        DefaultInstant begining2 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        cal.set(2012, 1, 1);
        DefaultInstant ending2 = new DefaultInstant((Position)new DefaultPosition(cal.getTime()));
        this.period1 = new DefaultPeriod((Instant)begining1, (Instant)ending1);
        this.period2 = new DefaultPeriod((Instant)begining2, (Instant)ending2);
    }

    @After
    public void tearDown() {
        this.period1 = null;
        this.period2 = null;
    }

    @Test
    public void testGetBeginning() {
        Instant result = this.period1.getBeginning();
        Assert.assertFalse((boolean)this.period2.getBeginning().equals(result));
    }

    @Test
    public void testSetBegining_Instant() {
        Instant result = this.period1.getBeginning();
        DefaultInstant newInstant = new DefaultInstant((Position)new DefaultPosition(new Date()));
        ((DefaultPeriod)this.period1).setBegining((Instant)newInstant);
        Assert.assertFalse((boolean)this.period1.getBeginning().equals(result));
    }

    @Test
    public void testSetBegining_Date() {
        Date result = this.period1.getBeginning().getPosition().getDate();
        ((DefaultPeriod)this.period1).setBegining(new Date());
        Assert.assertFalse((boolean)this.period1.getBeginning().getPosition().getDate().equals(result));
    }

    @Test
    public void testGetEnding() {
        Instant result = this.period1.getEnding();
        Assert.assertFalse((boolean)this.period2.getEnding().equals(result));
    }

    @Test
    public void testSetEnding_Instant() {
        Instant result = this.period1.getEnding();
        DefaultInstant newInstant = new DefaultInstant((Position)new DefaultPosition(new Date()));
        ((DefaultPeriod)this.period1).setEnding((Instant)newInstant);
        Assert.assertFalse((boolean)this.period1.getEnding().equals(result));
    }

    @Test
    public void testSetEnding_Date() {
        Date result = this.period1.getEnding().getPosition().getDate();
        ((DefaultPeriod)this.period1).setEnding(new Date());
        Assert.assertFalse((boolean)this.period1.getEnding().getPosition().getDate().equals(result));
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.period1.equals(null));
        Assert.assertEquals((Object)this.period1, (Object)this.period1);
        Assert.assertFalse((boolean)this.period1.equals(this.period2));
    }

    @Test
    public void testHashCode() {
        int result = this.period1.hashCode();
        Assert.assertFalse((this.period2.hashCode() == result ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        String result = this.period1.toString();
        Assert.assertFalse((boolean)this.period2.toString().equals(result));
    }
}

