/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.awt.Color;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class SLDTest
extends TestCase {
    StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    StyleBuilder sb = new StyleBuilder((FilterFactory)this.ff);

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testDefaults() {
        Stroke stroke = this.sf.getDefaultStroke();
        SLDTest.assertEquals((String)"default stroke width is one", (int)1, (int)SLD.width((Stroke)stroke));
        SLDTest.assertEquals((String)"default stroke color is black", (Object)Color.BLACK, (Object)SLD.color((Stroke)stroke));
    }

    public void testStroke() {
        Stroke stroke = this.sf.createStroke((Expression)this.ff.literal((Object)"#FF0000"), (Expression)this.ff.literal((Object)"3"));
        SLDTest.assertEquals((String)"width", (int)3, (int)SLD.width((Stroke)stroke));
        SLDTest.assertEquals((String)"color", (Object)Color.RED, (Object)SLD.color((Stroke)stroke));
        stroke = this.sf.createStroke((Expression)this.ff.literal((Object)"#FF0000"), (Expression)this.ff.literal((Object)"3.0"));
        SLDTest.assertEquals((String)"width", (int)3, (int)SLD.width((Stroke)stroke));
    }

    public void testSetRasterOpacity() {
        RasterSymbolizer rs = this.sb.createRasterSymbolizer();
        Style s = this.sb.createStyle((Symbolizer)rs);
        SLDTest.assertEquals((Object)1.0, (Object)SLD.opacity((RasterSymbolizer)SLD.rasterSymbolizer((Style)s)));
        SLD.setRasterOpacity((Style)s, (double)0.25);
        SLDTest.assertEquals((Object)0.25, (Object)SLD.opacity((RasterSymbolizer)SLD.rasterSymbolizer((Style)s)));
        SLDTest.assertNotSame((Object)SLD.rasterSymbolizer((Style)s), (Object)rs);
    }

    public void testSetRasterRGBChannels() {
        RasterSymbolizer rs = this.sb.createRasterSymbolizer();
        Style s = this.sb.createStyle((Symbolizer)rs);
        SelectedChannelType red = this.sf.createSelectedChannelType("red", this.sf.createContrastEnhancement((Expression)this.ff.literal(0.2)));
        SelectedChannelType green = this.sf.createSelectedChannelType("green", this.sf.createContrastEnhancement((Expression)this.ff.literal(0.4)));
        SelectedChannelType blue = this.sf.createSelectedChannelType("blue", this.sf.createContrastEnhancement((Expression)this.ff.literal(0.7)));
        SLD.setChannelSelection((Style)s, (SelectedChannelType[])new SelectedChannelType[]{red, green, blue}, null);
        SLDTest.assertNull((Object)SLD.rasterSymbolizer((Style)s).getChannelSelection().getGrayChannel());
        SLDTest.assertNotNull((Object)SLD.rasterSymbolizer((Style)s).getChannelSelection().getRGBChannels());
        SelectedChannelType[] selectedChannels = SLD.rasterSymbolizer((Style)s).getChannelSelection().getRGBChannels();
        SLDTest.assertEquals((String)"red", (String)((String)selectedChannels[0].getChannelName().evaluate(null, String.class)));
        SLDTest.assertEquals((String)"green", (String)((String)selectedChannels[1].getChannelName().evaluate(null, String.class)));
        SLDTest.assertEquals((String)"blue", (String)((String)selectedChannels[2].getChannelName().evaluate(null, String.class)));
        SLDTest.assertNotSame((Object)SLD.rasterSymbolizer((Style)s), (Object)rs);
    }
}

