/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.filter.function.math.FilterFunction_random;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.FeatureId;

public class SimplifyingFilterVisitorTest
extends TestCase {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    Id emptyFid;
    SimplifyingFilterVisitor simpleVisitor;
    SimplifyingFilterVisitor complexVisitor;
    PropertyIsEqualTo property;

    protected void setUp() throws Exception {
        this.emptyFid = this.ff.id(new HashSet());
        this.property = this.ff.equal((Expression)this.ff.property("test"), (Expression)this.ff.literal((Object)"oneTwoThree"), false);
        this.simpleVisitor = new SimplifyingFilterVisitor(){

            protected boolean isSimpleFeature() {
                return true;
            }
        };
        this.simpleVisitor.setRangeSimplicationEnabled(true);
        this.complexVisitor = new SimplifyingFilterVisitor();
    }

    protected void tearDown() throws Exception {
        EnvFunction.clearLocalValues();
    }

    public void testIncludeAndInclude() {
        Filter result = (Filter)this.ff.and((Filter)Filter.INCLUDE, (Filter)Filter.INCLUDE).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testIncludeAndExclude() {
        Filter result = (Filter)this.ff.and((Filter)Filter.INCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testExcludeAndExclude() {
        Filter result = (Filter)this.ff.and((Filter)Filter.EXCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testIncludeAndProperty() {
        Filter result = (Filter)this.ff.and((Filter)Filter.INCLUDE, (Filter)this.property).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)result);
    }

    public void testExcludeAndProperty() {
        Filter result = (Filter)this.ff.or((Filter)Filter.EXCLUDE, (Filter)this.property).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)result);
    }

    public void testIncludeOrInclude() {
        Filter result = (Filter)this.ff.or((Filter)Filter.INCLUDE, (Filter)Filter.INCLUDE).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testIncludeOrExclude() {
        Filter result = (Filter)this.ff.or((Filter)Filter.INCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testExcludeOrExclude() {
        Filter result = (Filter)this.ff.or((Filter)Filter.EXCLUDE, (Filter)Filter.EXCLUDE).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testIncludeOrProperty() {
        Filter result = (Filter)this.ff.or((Filter)Filter.INCLUDE, (Filter)this.property).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)result);
    }

    public void testExcludeOrProperty() {
        Filter result = (Filter)this.ff.or((Filter)Filter.EXCLUDE, (Filter)this.property).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)result);
    }

    public void testEmptyFid() {
        Filter result = (Filter)this.emptyFid.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)result);
    }

    public void testRecurseAnd() {
        And test = this.ff.and((Filter)Filter.INCLUDE, (Filter)this.ff.or((Filter)this.property, (Filter)Filter.EXCLUDE));
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)test.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testRecurseOr() {
        Or test = this.ff.or((Filter)Filter.EXCLUDE, (Filter)this.ff.and((Filter)this.property, (Filter)Filter.INCLUDE));
        SimplifyingFilterVisitorTest.assertEquals((Object)this.property, (Object)test.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testFidValidity() {
        this.simpleVisitor.setFIDValidator(new SimplifyingFilterVisitor.FIDValidator(){

            public boolean isValid(String fid) {
                return fid.startsWith("pass");
            }
        });
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("notPass"));
        Id filter = this.ff.id(ids);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)filter.accept((FilterVisitor)this.simpleVisitor, null));
        ids.add(this.ff.featureId("pass1"));
        ids.add(this.ff.featureId("pass2"));
        filter = this.ff.id(ids);
        HashSet<FeatureId> validIds = new HashSet<FeatureId>();
        validIds.add(this.ff.featureId("pass2"));
        validIds.add(this.ff.featureId("pass1"));
        Id expected = this.ff.id(validIds);
        SimplifyingFilterVisitorTest.assertEquals((Object)expected, (Object)filter.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testRegExFIDValidator() {
        SimplifyingFilterVisitor.RegExFIDValidator validator = new SimplifyingFilterVisitor.RegExFIDValidator("abc\\.\\d+");
        this.simpleVisitor.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)validator);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("abc.."));
        ids.add(this.ff.featureId(".abc.1"));
        ids.add(this.ff.featureId("abc.123"));
        ids.add(this.ff.featureId("abc.ax"));
        Id filter = this.ff.id(ids);
        Filter result = (Filter)filter.accept((FilterVisitor)this.simpleVisitor, null);
        Id expected = this.ff.id(Collections.singleton(this.ff.featureId("abc.123")));
        SimplifyingFilterVisitorTest.assertEquals((Object)expected, (Object)result);
    }

    public void testTypeNameDotNumberValidator() {
        String typeName = "states";
        SimplifyingFilterVisitor.TypeNameDotNumberFidValidator validator = new SimplifyingFilterVisitor.TypeNameDotNumberFidValidator("states");
        this.simpleVisitor.setFIDValidator((SimplifyingFilterVisitor.FIDValidator)validator);
        HashSet<FeatureId> ids = new HashSet<FeatureId>();
        ids.add(this.ff.featureId("_states"));
        ids.add(this.ff.featureId("states.abc"));
        ids.add(this.ff.featureId("states.."));
        ids.add(this.ff.featureId("states.123"));
        Id filter = this.ff.id(ids);
        Filter result = (Filter)filter.accept((FilterVisitor)this.simpleVisitor, null);
        Id expected = this.ff.id(Collections.singleton(this.ff.featureId("states.123")));
        SimplifyingFilterVisitorTest.assertEquals((Object)expected, (Object)result);
    }

    public void testNegateEquals() {
        Not f = this.ff.not((Filter)this.ff.equals((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.notEqual((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)), (Object)result);
        result = (Filter)f.accept((FilterVisitor)this.complexVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f, (Object)result);
    }

    public void testNegateGreater() {
        Not f = this.ff.not((Filter)this.ff.greater((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.lessOrEqual((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)), (Object)result);
        result = (Filter)f.accept((FilterVisitor)this.complexVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f, (Object)result);
    }

    public void testNegateGreaterOrEqual() {
        Not f = this.ff.not((Filter)this.ff.greaterOrEqual((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.less((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)), (Object)result);
        result = (Filter)f.accept((FilterVisitor)this.complexVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f, (Object)result);
    }

    public void testNegateLess() {
        Not f = this.ff.not((Filter)this.ff.less((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.greaterOrEqual((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)), (Object)result);
        result = (Filter)f.accept((FilterVisitor)this.complexVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f, (Object)result);
    }

    public void testNegateLessOrEqual() {
        Not f = this.ff.not((Filter)this.ff.lessOrEqual((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.greater((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)), (Object)result);
        result = (Filter)f.accept((FilterVisitor)this.complexVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f, (Object)result);
    }

    public void testNegateBetween() {
        PropertyName prop = this.ff.property("prop");
        Literal l10 = this.ff.literal(10);
        Literal l20 = this.ff.literal(20);
        Not f = this.ff.not((Filter)this.ff.between((Expression)prop, (Expression)l10, (Expression)l20));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.or(Arrays.asList(this.ff.less((Expression)prop, (Expression)l10), this.ff.greater((Expression)prop, (Expression)l20))), (Object)result);
    }

    public void testDoubleNegation() {
        PropertyIsEqualTo equal = this.ff.equals((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10));
        Not f = this.ff.not((Filter)this.ff.not((Filter)equal));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)equal, (Object)result);
    }

    public void testTripleNegation() {
        PropertyIsEqualTo equal = this.ff.equals((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10));
        Not f = this.ff.not((Filter)this.ff.not((Filter)this.ff.not((Filter)equal)));
        Filter result = (Filter)f.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.notEqual((Expression)this.ff.property("prop"), (Expression)this.ff.literal(10)), (Object)result);
    }

    public void testStableFunction() {
        EnvFunction.setLocalValue((String)"var", (Object)"123");
        Function f = this.ff.function("env", new Expression[]{this.ff.literal((Object)"var")});
        Expression result = (Expression)f.accept((ExpressionVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertTrue((boolean)(result instanceof Literal));
        SimplifyingFilterVisitorTest.assertEquals((String)"123", (String)((String)result.evaluate(null, String.class)));
    }

    public void testVolatileFunction() {
        Function f = this.ff.function("random", new Expression[0]);
        Expression result = (Expression)f.accept((ExpressionVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertTrue((boolean)(result instanceof FilterFunction_random));
    }

    public void testNestedVolatile() {
        EnvFunction.setLocalValue((String)"power", (Object)3);
        Function f = this.ff.function("pow", new Expression[]{this.ff.function("random", new Expression[0]), this.ff.function("env", new Expression[]{this.ff.literal((Object)"power")})});
        Function result = (Function)f.accept((ExpressionVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((String)"pow", (String)result.getName());
        Function param1 = (Function)result.getParameters().get(0);
        SimplifyingFilterVisitorTest.assertEquals((String)"random", (String)param1.getName());
        Expression param2 = (Expression)result.getParameters().get(1);
        SimplifyingFilterVisitorTest.assertTrue((boolean)(param2 instanceof Literal));
        SimplifyingFilterVisitorTest.assertEquals((Object)3, (Object)param2.evaluate(null, Integer.class));
    }

    public void testCompareFunctionNull() {
        Function f = this.ff.function("env", new Expression[]{this.ff.literal((Object)"var")});
        PropertyIsEqualTo filter = this.ff.equal((Expression)f, (Expression)this.ff.literal((Object)"test"), false);
        Filter simplified = (Filter)filter.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)simplified);
    }

    public void testCompareConstantFunction() {
        EnvFunction.setLocalValue((String)"var", (Object)"test");
        Function f = this.ff.function("env", new Expression[]{this.ff.literal((Object)"var")});
        PropertyIsEqualTo filter = this.ff.equal((Expression)f, (Expression)this.ff.literal((Object)"test"), false);
        Filter simplified = (Filter)filter.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)simplified);
    }

    public void testSimplifyStaticExclude() {
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)this.simplify((Filter)this.ff.greater((Expression)this.ff.literal(3), (Expression)this.ff.literal(5))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)this.simplify((Filter)this.ff.greaterOrEqual((Expression)this.ff.literal(3), (Expression)this.ff.literal(5))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)this.simplify((Filter)this.ff.less((Expression)this.ff.literal(5), (Expression)this.ff.literal(3))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)this.simplify((Filter)this.ff.lessOrEqual((Expression)this.ff.literal(5), (Expression)this.ff.literal(3))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)this.simplify((Filter)this.ff.equal((Expression)this.ff.literal(5), (Expression)this.ff.literal(3), true)));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)this.simplify((Filter)this.ff.between((Expression)this.ff.literal(3), (Expression)this.ff.literal(1), (Expression)this.ff.literal(2))));
    }

    public void testSimplifyStaticInclude() {
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)this.simplify((Filter)this.ff.less((Expression)this.ff.literal(3), (Expression)this.ff.literal(5))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)this.simplify((Filter)this.ff.lessOrEqual((Expression)this.ff.literal(3), (Expression)this.ff.literal(5))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)this.simplify((Filter)this.ff.greater((Expression)this.ff.literal(5), (Expression)this.ff.literal(3))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)this.simplify((Filter)this.ff.greaterOrEqual((Expression)this.ff.literal(5), (Expression)this.ff.literal(3))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)this.simplify((Filter)this.ff.equal((Expression)this.ff.literal(5), (Expression)this.ff.literal(5), true)));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)this.simplify((Filter)this.ff.between((Expression)this.ff.literal(3), (Expression)this.ff.literal(1), (Expression)this.ff.literal(4))));
    }

    private Filter simplify(Filter filter) {
        return (Filter)filter.accept((FilterVisitor)new SimplifyingFilterVisitor(), null);
    }

    public void testCoalesheNestedAnd() {
        PropertyIsEqualTo eq = this.ff.equal((Expression)this.ff.property("A"), (Expression)this.ff.literal((Object)"3"), true);
        PropertyIsGreaterThan gt = this.ff.greater((Expression)this.ff.property("b"), (Expression)this.ff.literal((Object)"3"));
        PropertyIsLessThan lt = this.ff.less((Expression)this.ff.property("c"), (Expression)this.ff.literal((Object)"5"));
        And nested = this.ff.and(Arrays.asList(this.ff.and(Arrays.asList(eq, gt)), lt));
        And simplified = (And)nested.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((int)3, (int)simplified.getChildren().size());
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.and(Arrays.asList(eq, gt, lt)), (Object)simplified);
    }

    public void testCoalesheNestedOr() {
        PropertyIsEqualTo eq = this.ff.equal((Expression)this.ff.property("A"), (Expression)this.ff.literal((Object)"3"), true);
        PropertyIsGreaterThan gt = this.ff.greater((Expression)this.ff.property("b"), (Expression)this.ff.literal((Object)"3"));
        PropertyIsLessThan lt = this.ff.less((Expression)this.ff.property("c"), (Expression)this.ff.literal((Object)"5"));
        Or nested = this.ff.or(Arrays.asList(this.ff.or(Arrays.asList(eq, gt)), lt));
        Or simplified = (Or)nested.accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((int)3, (int)simplified.getChildren().size());
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.or(Arrays.asList(eq, gt, lt)), (Object)simplified);
    }

    public void testDualFilterOr() {
        Or or = this.ff.or(Arrays.asList(this.ff.not((Filter)this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(3), true)), this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(3), true)));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)or.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testDualFilterAnd() {
        And original = this.ff.and(Arrays.asList(this.ff.not((Filter)this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(3), true)), this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(3), true)));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)original.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testDualFilterNullAnd() {
        And original = this.ff.and(Arrays.asList(this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property("a"))), this.ff.isNull((Expression)this.ff.property("a"))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)original.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testDualFilterNullOr() {
        Or original = this.ff.or(Arrays.asList(this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property("a"))), this.ff.isNull((Expression)this.ff.property("a"))));
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)original.accept((FilterVisitor)this.simpleVisitor, null));
    }

    public void testRepeatedFilter() {
        PropertyIsEqualTo f1 = this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(3), false);
        PropertyIsEqualTo f2 = this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(3), false);
        Filter s1 = (Filter)this.ff.and((Filter)f1, (Filter)f2).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f1, (Object)s1);
        Filter s2 = (Filter)this.ff.or((Filter)f1, (Filter)f2).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)f1, (Object)s2);
        PropertyIsGreaterThan f3 = this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.property("b"));
        Filter s3 = (Filter)this.ff.and(Arrays.asList(f1, f2, f3)).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.and(Arrays.asList(f1, f3)), (Object)s3);
        Filter s4 = (Filter)this.ff.and(Arrays.asList(f3, f1, f2)).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.and(Arrays.asList(f3, f1)), (Object)s4);
        Filter s5 = (Filter)this.ff.and(Arrays.asList(f1, f3, f2)).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.and(Arrays.asList(f1, f3)), (Object)s5);
        Filter s6 = (Filter)this.ff.or(Arrays.asList(f1, f2, f3)).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.or(Arrays.asList(f1, f3)), (Object)s6);
        Filter s7 = (Filter)this.ff.or(Arrays.asList(f3, f1, f2)).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.or(Arrays.asList(f3, f1)), (Object)s7);
        Filter s8 = (Filter)this.ff.or(Arrays.asList(f1, f3, f2)).accept((FilterVisitor)this.simpleVisitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.or(Arrays.asList(f1, f3)), (Object)s8);
    }

    public void testAndDisjointRanges() throws Exception {
        this.testAndDisjointRanges(Integer.class, 10, 5);
        this.testAndDisjointRanges(Byte.class, (byte)10, (byte)5);
        this.testAndDisjointRanges(Long.class, 10L, 5L);
        this.testAndDisjointRanges(Float.class, Float.valueOf(10.0f), Float.valueOf(5.0f));
        this.testAndDisjointRanges(Double.class, 10.0, 5.0);
        this.testAndDisjointRanges(String.class, "ppp", "bbb");
    }

    private <T> void testAndDisjointRanges(Class<T> type, T max, T min) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        And original = this.ff.and((Filter)this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(max)), (Filter)this.ff.less((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)original, (Object)simplified);
        visitor.setFeatureType((FeatureType)schema);
        Filter simplified2 = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.EXCLUDE, (Object)simplified2);
    }

    public void testOrDisjointRanges() throws Exception {
        this.testOrDisjointRanges(Integer.class, 10, 5);
        this.testOrDisjointRanges(Byte.class, (byte)10, (byte)5);
        this.testOrDisjointRanges(Long.class, 10L, 5L);
        this.testOrDisjointRanges(Float.class, Float.valueOf(10.0f), Float.valueOf(5.0f));
        this.testOrDisjointRanges(Double.class, 10.0, 5.0);
        this.testOrDisjointRanges(String.class, "ppp", "bbb");
    }

    private <T> void testOrDisjointRanges(Class<T> type, T max, T min) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setFeatureType((FeatureType)schema);
        Or original = this.ff.or((Filter)this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(max)), (Filter)this.ff.less((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)original, (Object)simplified);
    }

    public void testAndTouchingRanges() throws Exception {
        this.testAndTouchingRanges(Integer.class, 10);
        this.testAndTouchingRanges(Byte.class, (byte)10);
        this.testAndTouchingRanges(Long.class, 10L);
        this.testAndTouchingRanges(Float.class, Float.valueOf(10.0f));
        this.testAndTouchingRanges(Double.class, 10.0);
        this.testAndTouchingRanges(String.class, "ppp");
    }

    private <T> void testAndTouchingRanges(Class<T> type, T value) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        And original = this.ff.and((Filter)this.ff.greaterOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(value)), (Filter)this.ff.lessOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(value)));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.equal((Expression)this.ff.property("a"), (Expression)this.ff.literal(value), false), (Object)simplified);
    }

    public void testOrTouchingRanges() throws Exception {
        this.testOrTouchingRanges(Integer.class, 10);
        this.testOrTouchingRanges(Byte.class, (byte)10);
        this.testOrTouchingRanges(Long.class, 10L);
        this.testOrTouchingRanges(Float.class, Float.valueOf(10.0f));
        this.testOrTouchingRanges(Double.class, 10.0);
        this.testOrTouchingRanges(String.class, "ppp");
    }

    private <T> void testOrTouchingRanges(Class<T> type, T value) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        Or original = this.ff.or((Filter)this.ff.greaterOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(value)), (Filter)this.ff.lessOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(value)));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)simplified);
    }

    public void testAndOverlappingRanges() throws Exception {
        this.testAndOverlappingRanges(Integer.class, 5, 7, 10);
        this.testAndOverlappingRanges(Byte.class, (byte)5, (byte)7, (byte)10);
        this.testAndOverlappingRanges(Long.class, 5L, 7L, 10L);
        this.testAndOverlappingRanges(Float.class, Float.valueOf(5.0f), Float.valueOf(7.0f), Float.valueOf(10.0f));
        this.testAndOverlappingRanges(Double.class, 5.0, 7.0, 10.0);
        this.testAndOverlappingRanges(String.class, "bbb", "nnn", "ppp");
    }

    private <T> void testAndOverlappingRanges(Class<T> type, T min, T mid, T max) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        And original = this.ff.and(Arrays.asList(this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)), this.ff.less((Expression)this.ff.property("a"), (Expression)this.ff.literal(max)), this.ff.less((Expression)this.ff.property("a"), (Expression)this.ff.literal(mid))));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.and((Filter)this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)), (Filter)this.ff.less((Expression)this.ff.property("a"), (Expression)this.ff.literal(mid))), (Object)simplified);
    }

    public void testOrOverlappingRanges() throws Exception {
        this.testOrOverlappingRanges(Integer.class, 5, 10);
        this.testOrOverlappingRanges(Byte.class, (byte)5, (byte)10);
        this.testOrOverlappingRanges(Long.class, 5L, 10L);
        this.testOrOverlappingRanges(Float.class, Float.valueOf(5.0f), Float.valueOf(10.0f));
        this.testOrOverlappingRanges(Double.class, 5.0, 10.0);
        this.testOrOverlappingRanges(String.class, "bbb", "ppp");
    }

    private <T> void testOrOverlappingRanges(Class<T> type, T min, T max) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        Or original = this.ff.or(Arrays.asList(this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)), this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(max))));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)), (Object)simplified);
    }

    public void testAndOverlappingRangesToBetween() throws Exception {
        this.testAndOverlappingRangesToBetween(Integer.class, 5, 7, 10);
        this.testAndOverlappingRangesToBetween(Byte.class, (byte)5, (byte)7, (byte)10);
        this.testAndOverlappingRangesToBetween(Long.class, 5L, 7L, 10L);
        this.testAndOverlappingRangesToBetween(Float.class, Float.valueOf(5.0f), Float.valueOf(7.0f), Float.valueOf(10.0f));
        this.testAndOverlappingRangesToBetween(Double.class, 5.0, 7.0, 10.0);
        this.testAndOverlappingRangesToBetween(String.class, "bbb", "nnn", "ppp");
    }

    private <T> void testAndOverlappingRangesToBetween(Class<T> type, T min, T mid, T max) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        And original = this.ff.and(Arrays.asList(this.ff.greaterOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)), this.ff.less((Expression)this.ff.property("a"), (Expression)this.ff.literal(max)), this.ff.lessOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(mid))));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.between((Expression)this.ff.property("a"), (Expression)this.ff.literal(min), (Expression)this.ff.literal(mid)), (Object)simplified);
    }

    public void testOrPseudoBetween() throws Exception {
        this.testOrPseudoBetween(Integer.class, 5, 10);
        this.testOrPseudoBetween(Byte.class, (byte)5, (byte)10);
        this.testOrPseudoBetween(Long.class, 5L, 10L);
        this.testOrPseudoBetween(Float.class, Float.valueOf(5.0f), Float.valueOf(10.0f));
        this.testOrPseudoBetween(Double.class, 5.0, 10.0);
        this.testOrPseudoBetween(String.class, "bbb", "ppp");
    }

    private <T> void testOrPseudoBetween(Class<T> type, T min, T max) throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)("a:" + type.getName()));
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        Or original = this.ff.or(Arrays.asList(this.ff.and((Filter)this.ff.greater((Expression)this.ff.property("a"), (Expression)this.ff.literal(min)), (Filter)this.ff.lessOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(max))), this.ff.lessOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(min))));
        Filter simplified = (Filter)original.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.lessOrEqual((Expression)this.ff.property("a"), (Expression)this.ff.literal(max)), (Object)simplified);
    }

    public void testRangeExpression() throws Exception {
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)"pop:String");
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setRangeSimplicationEnabled(true);
        visitor.setFeatureType((FeatureType)schema);
        Function func = this.ff.function("parseLong", new Expression[]{this.ff.property("pop")});
        PropertyIsLessThan f1 = this.ff.less((Expression)func, (Expression)this.ff.literal(20000));
        PropertyIsBetween f2 = this.ff.between((Expression)func, (Expression)this.ff.literal(20000), (Expression)this.ff.literal(50000));
        Or or = this.ff.or((Filter)f1, (Filter)f2);
        Filter simplified = (Filter)or.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)this.ff.lessOrEqual((Expression)func, (Expression)this.ff.literal(50000)), (Object)simplified);
    }

    public void testSimplifyNegateImpossible() throws Exception {
        PropertyIsEqualTo propertyIsEqualTo = this.ff.equal((Expression)this.ff.literal((Object)"a"), (Expression)this.ff.literal((Object)"b"), true);
        Not negated = this.ff.not((Filter)propertyIsEqualTo);
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        SimpleFeatureType schema = DataUtilities.createType((String)"test", (String)"pop:String");
        visitor.setFeatureType((FeatureType)schema);
        Filter simplified = (Filter)negated.accept((FilterVisitor)visitor, null);
        SimplifyingFilterVisitorTest.assertEquals((Object)Filter.INCLUDE, (Object)simplified);
    }
}

