/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.InternalFunction;

public class DuplicatorFilterVisitorTest
extends TestCase {
    FilterFactory fac;

    public DuplicatorFilterVisitorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.fac = CommonFactoryFinder.getFilterFactory(null);
    }

    public void testLogicFilterDuplication() throws IllegalFilterException {
        ArrayList<PropertyIsGreaterThan> filters = new ArrayList<PropertyIsGreaterThan>();
        PropertyIsGreaterThan filter1 = this.fac.greater((Expression)this.fac.literal(2), (Expression)this.fac.literal(1));
        filters.add(filter1);
        PropertyIsGreaterThan filter2 = this.fac.greater((Expression)this.fac.literal(4), (Expression)this.fac.literal(3));
        filters.add(filter2);
        And oldFilter = this.fac.and(filters);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor((FilterFactory2)this.fac);
        Filter newFilter = (Filter)oldFilter.accept((FilterVisitor)visitor, null);
        DuplicatorFilterVisitorTest.assertNotNull((Object)newFilter);
    }

    public void testDuplicateInternalFunction() throws IllegalFilterException {
        class TestInternalFunction
        extends InternalVolatileFunction {
            TestInternalFunction() {
            }

            public Object evaluate(Object object) {
                return null;
            }

            public InternalFunction duplicate(Expression ... parameters) {
                return new TestInternalFunction();
            }
        }
        TestInternalFunction internalFunction = new TestInternalFunction();
        PropertyIsNull filter = this.fac.isNull((Expression)internalFunction);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor((FilterFactory2)this.fac);
        Filter newFilter = (Filter)filter.accept((FilterVisitor)visitor, null);
        DuplicatorFilterVisitorTest.assertTrue((boolean)(newFilter instanceof PropertyIsNull));
        Expression newExpression = ((PropertyIsNull)newFilter).getExpression();
        DuplicatorFilterVisitorTest.assertNotNull((Object)newExpression);
        DuplicatorFilterVisitorTest.assertTrue((boolean)(newExpression instanceof TestInternalFunction));
        DuplicatorFilterVisitorTest.assertNotSame((Object)((Object)internalFunction), (Object)newExpression);
    }
}

