/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.logging.Logger;
import java.util.stream.DoubleStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.filter.function.StandardDeviationFunction;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class StandardDeviationFunctionTest
extends FunctionTestSupport {
    private static final Logger LOGGER = Logging.getLogger(StandardDeviationFunctionTest.class);

    public StandardDeviationFunctionTest(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(StandardDeviationFunctionTest.class);
        return suite;
    }

    public void testInstance() {
        Function stdDev = this.ff.function("StandardDeviation", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        StandardDeviationFunctionTest.assertNotNull((Object)stdDev);
    }

    public void testGetName() {
        Function equInt = this.ff.function("StandardDeviation", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        LOGGER.finer("testGetName");
        StandardDeviationFunctionTest.assertEquals((String)"StandardDeviation", (String)equInt.getName());
    }

    public void testSetNumberOfClasses() throws Exception {
        LOGGER.finer("testSetNumberOfClasses");
        Literal classes = this.ff.literal(3);
        PropertyName exp = this.ff.property("foo");
        StandardDeviationFunction func = (StandardDeviationFunction)this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        StandardDeviationFunctionTest.assertEquals((int)3, (int)func.getClasses());
        classes = this.ff.literal(12);
        func = (StandardDeviationFunction)this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        StandardDeviationFunctionTest.assertEquals((int)12, (int)func.getClasses());
    }

    public void testGetValue() throws Exception {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("foo");
        Function standardDeviation = this.ff.function("StandardDeviation", new Expression[]{exp, classes});
        StandardDeviationFunctionTest.assertNotNull((String)"step 1 - standard deviation function", (Object)standardDeviation);
        final Classifier classifer = (Classifier)standardDeviation.evaluate((Object)this.featureCollection, Classifier.class);
        this.featureCollection.accepts(new FeatureVisitor(){

            public void visit(Feature f) {
                SimpleFeature feature = (SimpleFeature)f;
                Object value = feature.getAttribute("foo");
                TestCase.assertNotNull((String)(feature.getID() + " foo"), (Object)value);
                int slot = classifer.classify(value);
                TestCase.assertNotNull((String)("Slot " + slot), (Object)classifer.getTitle(slot));
            }
        }, null);
        Function classify = this.ff.function("classify", new Expression[]{exp, this.ff.literal((Object)classifer)});
        StandardDeviationFunctionTest.assertNotNull((String)"step 2 - classify function", (Object)classify);
        SimpleFeatureIterator list = this.featureCollection.features();
        SimpleFeature f = (SimpleFeature)list.next();
        Integer slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)1, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)4, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)2, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)2, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)2, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)3, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)1, (int)slot);
        f = (SimpleFeature)list.next();
        slot = (Integer)classify.evaluate((Object)f, Integer.class);
        StandardDeviationFunctionTest.assertEquals((String)("value " + f.getAttribute("foo")), (int)1, (int)slot);
    }

    public void testConstantValuesNumeric() {
        Function function = this.ff.function("StandardDeviation", new Expression[]{this.ff.property("v"), this.ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        StandardDeviationFunctionTest.assertNotNull((Object)classifier);
        StandardDeviationFunctionTest.assertEquals((int)1, (int)classifier.getSize());
        StandardDeviationFunctionTest.assertEquals((double)123.123, (double)((Double)classifier.getMin(0)), (double)0.0);
        StandardDeviationFunctionTest.assertEquals((double)123.123, (double)((Double)classifier.getMax(0)), (double)0.0);
    }

    public void testPercentagesOddClassNum() {
        Literal classes = this.ff.literal(5);
        PropertyName exp = this.ff.property("foo");
        Function standardDeviation = this.ff.function("StandardDeviation", new Expression[]{exp, classes, this.ff.literal(true)});
        StandardDeviationFunctionTest.assertNotNull((String)"step 1 - standard deviation function", (Object)standardDeviation);
        Classifier classifier = (Classifier)standardDeviation.evaluate((Object)this.stddevCollection, Classifier.class);
        double[] percentages = classifier.getPercentages();
        StandardDeviationFunctionTest.assertNotNull((Object)percentages);
        StandardDeviationFunctionTest.assertEquals((int)5, (int)percentages.length);
        StandardDeviationFunctionTest.assertEquals((Object)10.0, (Object)percentages[0]);
        StandardDeviationFunctionTest.assertEquals((Object)0.0, (Object)percentages[1]);
        StandardDeviationFunctionTest.assertEquals((Object)70.0, (Object)percentages[2]);
        StandardDeviationFunctionTest.assertEquals((Object)10.0, (Object)percentages[3]);
        StandardDeviationFunctionTest.assertEquals((Object)10.0, (Object)percentages[4]);
        StandardDeviationFunctionTest.assertEquals((Object)100.0, (Object)DoubleStream.of(percentages).sum());
    }

    public void testPercentagesEvenClassNum() {
        Literal classes = this.ff.literal(6);
        PropertyName exp = this.ff.property("foo");
        Function standardDeviation = this.ff.function("StandardDeviation", new Expression[]{exp, classes, this.ff.literal(true)});
        StandardDeviationFunctionTest.assertNotNull((String)"step 1 - standard deviation function", (Object)standardDeviation);
        Classifier classifier = (Classifier)standardDeviation.evaluate((Object)this.stddevCollection, Classifier.class);
        double[] percentages = classifier.getPercentages();
        StandardDeviationFunctionTest.assertNotNull((Object)percentages);
        StandardDeviationFunctionTest.assertEquals((int)6, (int)percentages.length);
        StandardDeviationFunctionTest.assertEquals((Object)10.0, (Object)percentages[0]);
        StandardDeviationFunctionTest.assertEquals((Object)0.0, (Object)percentages[1]);
        StandardDeviationFunctionTest.assertEquals((Object)50.0, (Object)percentages[2]);
        StandardDeviationFunctionTest.assertEquals((Object)30.0, (Object)percentages[3]);
        StandardDeviationFunctionTest.assertEquals((Object)0.0, (Object)percentages[4]);
        StandardDeviationFunctionTest.assertEquals((Object)10.0, (Object)percentages[5]);
        StandardDeviationFunctionTest.assertEquals((Object)100.0, (Object)DoubleStream.of(percentages).sum());
    }
}

