/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class MapGetFunctionTest
extends TestCase {
    static FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private SimpleFeatureType sampleDataType;
    private String namespace = "ns";
    private SimpleFeature[] features;
    private GeometryFactory gf;

    protected void setUp() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("map");
        builder.setNamespaceURI(this.namespace);
        builder.add(this.createAttribute("id", String.class));
        builder.add(this.createAttribute("geom", LineString.class));
        builder.setDefaultGeometry("geom");
        builder.add(this.createAttribute("name", String.class));
        builder.add(this.createAttribute("attributes", Map.class));
        this.sampleDataType = builder.buildFeatureType();
        this.gf = new GeometryFactory();
        this.features = new SimpleFeature[3];
        this.features[0] = SimpleFeatureBuilder.build((SimpleFeatureType)this.sampleDataType, (Object[])new Object[]{1, this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "object1", new HashMap<String, Object>(){
            {
                this.put("name", "firstObject");
                this.put("valid", false);
                this.put("score", 100);
                this.put("key1", "value1");
            }
        }}, (String)"sample.s1");
        this.features[1] = SimpleFeatureBuilder.build((SimpleFeatureType)this.sampleDataType, (Object[])new Object[]{2, this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "object2", new HashMap<String, Object>(){
            {
                this.put("name", "secondObject");
                this.put("valid", true);
                this.put("score", 50);
                this.put("key1", 10);
            }
        }}, (String)"sample.s2");
        this.features[2] = SimpleFeatureBuilder.build((SimpleFeatureType)this.sampleDataType, (Object[])new Object[]{2, this.line(new int[]{3, 2, 4, 2, 5, 3}), "object3", new HashMap<String, Object>(){
            {
                this.put("name", "thirdObject");
                this.put("score", 70);
                this.put("key1", true);
            }
        }}, (String)"sample.s3");
    }

    private AttributeDescriptor createAttribute(String name, Class clazz) {
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl(name), clazz, false, false, Collections.emptyList(), null, null);
        return new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl(name), 0, 1, false, null);
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return this.gf.createLineString(coords);
    }

    @Test
    public void testEvaluate() {
        Function f = FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"name")});
        MapGetFunctionTest.assertEquals((String)"firstObject", (String)((String)f.evaluate((Object)this.features[0], String.class)));
        MapGetFunctionTest.assertEquals((String)"secondObject", (String)((String)f.evaluate((Object)this.features[1], String.class)));
        MapGetFunctionTest.assertEquals((String)"thirdObject", (String)((String)f.evaluate((Object)this.features[2], String.class)));
        PropertyIsGreaterThan gt = FF.greater((Expression)FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"score")}), (Expression)FF.literal(80));
        MapGetFunctionTest.assertEquals((boolean)true, (boolean)gt.evaluate((Object)this.features[0]));
        MapGetFunctionTest.assertEquals((boolean)false, (boolean)gt.evaluate((Object)this.features[1]));
        MapGetFunctionTest.assertEquals((boolean)false, (boolean)gt.evaluate((Object)this.features[2]));
        Function f2 = FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"valid")});
        MapGetFunctionTest.assertFalse((boolean)((Boolean)f2.evaluate((Object)this.features[0], Boolean.class)));
        MapGetFunctionTest.assertTrue((boolean)((Boolean)f2.evaluate((Object)this.features[1], Boolean.class)));
        MapGetFunctionTest.assertNull((Object)f2.evaluate((Object)this.features[2], Boolean.class));
        Function f3 = FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"key1")});
        MapGetFunctionTest.assertEquals((String)"value1", (String)((String)f3.evaluate((Object)this.features[0], String.class)));
        MapGetFunctionTest.assertEquals((Object)10, (Object)f3.evaluate((Object)this.features[1], Integer.class));
        MapGetFunctionTest.assertEquals((Object)Boolean.TRUE, (Object)f3.evaluate((Object)this.features[2], Boolean.class));
        Function f4 = FF.function("mapGet", new Expression[]{FF.property("missingMap"), FF.literal((Object)"key1")});
        MapGetFunctionTest.assertNull((Object)f4.evaluate((Object)this.features[0], String.class));
    }
}

