/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.function.FunctionTestSupport;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;

public class InFunctionTest
extends FunctionTestSupport {
    private static final String FUNCTION_NAME = "in";
    private SimpleFeature feature;

    public InFunctionTest(String testName) {
        super(testName);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.feature = (SimpleFeature)this.featureCollection.features().next();
    }

    public void testIntPresent() {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal(3), this.ff.literal(4), this.ff.literal(5)});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
    }

    public void testIntMissing() {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal(1), this.ff.literal(2)});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)false, (Object)result);
    }

    public void testDoublePresent() {
        PropertyName exp = this.ff.property("bar");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal(2.5), this.ff.literal(2.6), this.ff.literal(3.0)});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
    }

    public void testDoubleMissing() {
        PropertyName exp = this.ff.property("bar");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal(2.499999), this.ff.literal((Object)"2.500001"), this.ff.literal(2)});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)false, (Object)result);
    }

    public void testStringPresent() {
        PropertyName exp = this.ff.property("group");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal((Object)"Group0"), this.ff.literal((Object)"Group1")});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
    }

    public void testStringMissing() {
        PropertyName exp = this.ff.property("group");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal((Object)"Group1"), this.ff.literal((Object)"Group2"), this.ff.literal((Object)"Group3")});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)false, (Object)result);
    }

    public void testMixedType() {
        PropertyName exp = this.ff.property("group");
        Expression[] args = new Expression[]{exp, this.ff.literal(1), this.ff.literal(2.5), this.ff.literal((Object)"Group1"), this.ff.literal(4)};
        Function func = this.ff.function(FUNCTION_NAME, args);
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)false, (Object)result);
        exp = this.ff.property("foo");
        args[0] = exp;
        func = this.ff.function(FUNCTION_NAME, args);
        result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
        exp = this.ff.property("bar");
        args[0] = exp;
        func = this.ff.function(FUNCTION_NAME, args);
        result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
    }

    public void testLongList() {
        int NUM_ARGS = 500;
        PropertyName exp = this.ff.property("group");
        Expression[] args = new Expression[501];
        args[0] = exp;
        for (int i = 1; i <= 500; ++i) {
            args[i] = this.ff.literal((Object)("Group" + i));
        }
        Function func = this.ff.function(FUNCTION_NAME, args);
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)false, (Object)result);
        this.feature.setAttribute("group", (Object)"Group250");
        result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
    }

    public void testNullComparison() {
        PropertyName exp = this.ff.property("not_there");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal(1), this.ff.literal(null)});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
        func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal((Object)"1"), this.ff.literal(2)});
        result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)false, (Object)result);
    }

    public void testTypelessComparison() {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal((Object)"4")});
        Object result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
        func = this.ff.function(FUNCTION_NAME, new Expression[]{exp, this.ff.literal(4.0)});
        result = func.evaluate((Object)this.feature);
        InFunctionTest.assertEquals((Object)true, (Object)result);
    }
}

