/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.GeometryTransformation;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FilterFunction_offsetTest {
    @Test
    public void testInvert() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Function function = ff.function("offset", new Expression[]{ff.property("the_geom"), ff.literal(1), ff.literal(2)});
        Assert.assertTrue((boolean)(function instanceof GeometryTransformation));
        GeometryTransformation gt = (GeometryTransformation)function;
        ReferencedEnvelope re = new ReferencedEnvelope(0.0, 1.0, 0.0, 1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope inverted = gt.invert(re);
        ReferencedEnvelope expected = new ReferencedEnvelope(-1.0, 0.0, -2.0, -1.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Assert.assertEquals((Object)expected, (Object)inverted);
    }
}

