/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.FilterFunction_octagonalEnvelope;
import org.geotools.filter.function.FunctionTestFixture;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.OctagonalEnvelope;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FilterFunction_octagonalEnvelopeTest {
    @Test
    public void testGetArgCount() {
        FilterFunction_octagonalEnvelope f = new FilterFunction_octagonalEnvelope();
        Assert.assertEquals((long)1L, (long)f.getFunctionName().getArgumentCount());
    }

    @Test
    public void getName() {
        FilterFunction_octagonalEnvelope f = new FilterFunction_octagonalEnvelope();
        Assert.assertEquals((Object)"octagonalenvelope", (Object)f.getName());
    }

    @Test
    public void testEvaluate() throws Exception {
        SimpleFeatureCollection featureCollection = FunctionTestFixture.polygons();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        Function exp = ff.function("octagonalenvelope", new Expression[]{ff.property("geom")});
        SimpleFeatureIterator iter = featureCollection.features();
        while (iter.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iter.next();
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            Geometry octagonalEnvelope = new OctagonalEnvelope(geom).toGeometry(geom.getFactory());
            Object value = exp.evaluate((Object)feature);
            Assert.assertTrue((boolean)(value instanceof Polygon));
            Assert.assertTrue((boolean)octagonalEnvelope.equalsExact((Geometry)value, 0.1));
        }
        iter.close();
        Assert.assertNull((Object)exp.evaluate(null));
    }
}

