/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.HashSet;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.filter.function.FunctionTestSupport;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;

public class Collection_FunctionsTest
extends FunctionTestSupport {
    public Collection_FunctionsTest(String testName) {
        super(testName);
    }

    public void testInstance() {
        Function cmin = this.ff.function("Collection_Min", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Collection_FunctionsTest.assertNotNull((Object)cmin);
    }

    public void testAverage() throws Exception {
        this.performNumberTest("Collection_Average", 33.375);
    }

    public void testCount() throws Exception {
        this.performNumberTest("Collection_Count", 8);
    }

    public void testMin() throws Exception {
        this.performNumberTest("Collection_Min", 4);
    }

    public void testMedian() throws Exception {
        this.performNumberTest("Collection_Median", 24.5);
    }

    public void testMax() throws Exception {
        this.performNumberTest("Collection_Max", 90);
    }

    public void testSum() throws Exception {
        this.performNumberTest("Collection_Sum", 267);
    }

    public void testUnique() throws Exception {
        HashSet<Integer> result = new HashSet<Integer>(8);
        result.add(90);
        result.add(4);
        result.add(8);
        result.add(43);
        result.add(61);
        result.add(20);
        result.add(29);
        result.add(12);
        this.performObjectTest("Collection_Unique", result);
    }

    public void testNearest() throws Exception {
        Function func = this.ff.function("Collection_Nearest", new Expression[]{this.ff.property("foo"), this.ff.literal(9)});
        Object match = func.evaluate((Object)this.featureCollection);
        Collection_FunctionsTest.assertEquals((String)"Nearest to 9 is 8", (Object)8, (Object)match);
    }

    public void testCountFunctionDescription() throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Collection_Count", new Expression[]{exp});
        Collection_FunctionsTest.assertEquals((int)func.getParameters().size(), (int)1);
        Collection_FunctionsTest.assertEquals((String)func.getFunctionName().getReturn().toString(), (String)"count:Number");
    }

    public void performNumberTest(String functionName, Object expectedValue) throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(functionName, new Expression[]{exp});
        Object obj = func.evaluate((Object)this.featureCollection);
        Number result = (Number)obj;
        Number expected = (Number)expectedValue;
        Collection_FunctionsTest.assertEquals((double)expected.doubleValue(), (double)result.doubleValue(), (double)0.0);
    }

    public void performObjectTest(String functionName, Object expectedValue) throws Exception {
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function(functionName, new Expression[]{exp});
        Object result = func.evaluate((Object)this.featureCollection);
        Collection_FunctionsTest.assertEquals((Object)expectedValue, (Object)result);
    }
}

