/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.logging.Logger;
import org.geotools.filter.function.EqualIntervalFunction;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.Expression;

public class ClassificationFunctionTest
extends FunctionTestSupport {
    protected static final Logger LOGGER = Logging.getLogger(ClassificationFunctionTest.class);

    public ClassificationFunctionTest(String testName) {
        super(testName);
    }

    public void testDecimalPlaces() throws Exception {
        EqualIntervalFunction eif = (EqualIntervalFunction)this.ff.function("EqualInterval", new Expression[]{Expression.NIL});
        ClassificationFunctionTest.assertEquals((int)0, (int)eif.decimalPlaces(100.0));
        ClassificationFunctionTest.assertEquals((int)3, (int)eif.decimalPlaces(25.99312));
        ClassificationFunctionTest.assertEquals((int)1, (int)eif.decimalPlaces(1.1));
        ClassificationFunctionTest.assertEquals((int)1, (int)eif.decimalPlaces(0.9));
        ClassificationFunctionTest.assertEquals((int)1, (int)eif.decimalPlaces(0.1));
        ClassificationFunctionTest.assertEquals((int)2, (int)eif.decimalPlaces(0.01));
        ClassificationFunctionTest.assertEquals((int)3, (int)eif.decimalPlaces(0.001));
    }

    public void testRound() throws Exception {
        QuantileFunction classifier = (QuantileFunction)this.ff.function("Quantile", new Expression[]{Expression.NIL});
        ClassificationFunctionTest.assertEquals((double)100.0, (double)classifier.round(100.0, 0), (double)0.0);
        ClassificationFunctionTest.assertEquals((double)1.1, (double)classifier.round(1.12, 1), (double)0.0);
        ClassificationFunctionTest.assertEquals((double)0.35, (double)classifier.round(0.34523, 2), (double)0.0);
    }

    public void testRoundOverflow() throws Exception {
        EqualIntervalFunction eif = (EqualIntervalFunction)this.ff.function("EqualInterval", new Expression[]{Expression.NIL});
        ClassificationFunctionTest.assertEquals((Object)1.4779463384953E12, (Object)eif.round(1.47794633849525E12, 1));
    }
}

