/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.Date;
import junit.framework.TestCase;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.filter.capability.FunctionName;
import org.opengis.parameter.Parameter;

public class FunctionImplTest
extends TestCase {
    public void testFunctionName() throws Exception {
        FunctionName fn = FunctionImpl.functionName((String)"foo", (String)"bar:Integer", (String[])new String[]{"a", "x:String:1,1", "y:MultiPolygon", "z:java.util.Date:1,"});
        FunctionImplTest.assertEquals((String)"foo", (String)fn.getName());
        this.check(fn.getReturn(), "bar", Integer.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(0), "a", Object.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(1), "x", String.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(2), "y", MultiPolygon.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(3), "z", Date.class, 1, -1);
        fn = FunctionImpl.functionName((String)"foo", (String)"a", (String[])new String[]{"geom::1,1", "b:Object:,"});
        this.check((Parameter)fn.getArguments().get(0), "geom", Geometry.class, 1, 1);
        this.check((Parameter)fn.getArguments().get(1), "b", Object.class, -1, -1);
        fn = FunctionImpl.functionName((String)"foo", (String)"value", (String[])new String[]{"geom::,"});
        this.check((Parameter)fn.getArguments().get(0), "geom", Geometry.class, -1, -1);
    }

    public void testToString() throws Exception {
        FunctionImpl func = new FunctionImpl();
        LiteralExpressionImpl param = new LiteralExpressionImpl(42);
        func.setName("TestFunction");
        func.setParameters(Collections.singletonList(param));
        String result = func.toString();
        FunctionImplTest.assertEquals((String)"TestFunction([42])", (String)result);
    }

    void check(Parameter p, String name, Class type, int min, int max) {
        FunctionImplTest.assertEquals((String)name, (String)p.getName());
        FunctionImplTest.assertEquals((Object)type, (Object)p.getType());
        FunctionImplTest.assertEquals((int)min, (int)p.getMinOccurs());
        FunctionImplTest.assertEquals((int)max, (int)p.getMaxOccurs());
    }
}

