/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.function.InterpolateFunction;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Function;

public class FunctionFinderTest {
    static FilterFactory ff;
    FunctionFinder finder;
    Function function;
    private FunctionName name;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ff = CommonFactoryFinder.getFilterFactory(null);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        ff = null;
    }

    @Before
    public void setUp() throws Exception {
        this.finder = new FunctionFinder(new Hints((RenderingHints.Key)Hints.FILTER_FACTORY, (Object)ff));
    }

    @After
    public void tearDown() throws Exception {
        this.finder = null;
    }

    @Test
    public void testAllFunctionDescriptions() throws Exception {
        List all = this.finder.getAllFunctionDescriptions();
        Assert.assertTrue((all.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (FunctionName name : all) {
            if (!name.getName().equals("Interpolate")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Found Interpolate", (boolean)found);
    }

    @Test
    public void testFindInteropolate() throws Exception {
        this.function = this.finder.findFunction("interpolate");
        Assert.assertNotNull((String)"interpolate", (Object)this.function);
        Assert.assertTrue((boolean)(this.function instanceof InterpolateFunction));
        this.function = this.finder.findFunction("Interpolate");
        Assert.assertNotNull((String)"Interpolate", (Object)this.function);
        Assert.assertTrue((boolean)(this.function instanceof InterpolateFunction));
        this.function = this.finder.findFunction("INTERPOLATE");
        Assert.assertNotNull((String)"INTERPOLATE", (Object)this.function);
        Assert.assertTrue((String)"fallback", (boolean)(this.function instanceof InterpolateFunction));
        this.name = this.finder.findFunctionDescription("interpolate");
        Assert.assertNull((String)"interpolate", (Object)this.name);
        this.name = this.finder.findFunctionDescription("Interpolate");
        Assert.assertNotNull((String)"Interpolate", (Object)this.name);
        this.name = this.finder.findFunctionDescription("INTERPOLATE");
        Assert.assertNull((String)"INTERPOLATE", (Object)this.name);
    }
}

