/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;

public class FilterCapabilitiesTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger(FilterCapabilitiesTest.class);
    private Filter gFilter;
    private Filter compFilter;
    private Filter logFilter;
    private FilterCapabilities capabilities;
    private FilterFactory2 fact = CommonFactoryFinder.getFilterFactory2();
    TestSuite suite = null;
    String dataFolder = "";
    boolean setup = false;

    public FilterCapabilitiesTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FilterCapabilitiesTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterCapabilitiesTest.class);
        return suite;
    }

    protected void setUp() {
        LOGGER.finer("Setting up FilterCapabilitiesTest");
        if (this.setup) {
            return;
        }
        this.setup = true;
        this.capabilities = new FilterCapabilities();
        try {
            this.gFilter = this.fact.within((Expression)this.fact.property("geom"), (Expression)this.fact.literal(null));
            this.compFilter = this.fact.less((Expression)this.fact.property("size"), (Expression)this.fact.literal(3));
        }
        catch (IllegalFilterException ife) {
            LOGGER.fine("Bad filter " + (Object)((Object)ife));
        }
        this.capabilities.addType(Or.class);
        this.capabilities.addType(And.class);
        this.capabilities.addType(Not.class);
        this.capabilities.addType(PropertyIsEqualTo.class);
        this.capabilities.addType(PropertyIsLessThan.class);
        this.capabilities.addType(PropertyIsBetween.class);
    }

    public void testAdd() {
        this.capabilities.addType(PropertyIsGreaterThan.class);
        this.capabilities.addType(PropertyIsLessThan.class);
        this.capabilities.addType(PropertyIsNull.class);
        FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.supports(PropertyIsNull.class));
    }

    public void testShortSupports() {
        FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.supports(And.class));
        FilterCapabilitiesTest.assertTrue((!this.capabilities.supports(PropertyIsLike.class) ? 1 : 0) != 0);
    }

    public void testFilterSupports() {
        FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.supports(this.compFilter));
        FilterCapabilitiesTest.assertTrue((!this.capabilities.supports(this.gFilter) ? 1 : 0) != 0);
    }

    public void testFullySupports() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        try {
            this.logFilter = ff.and(this.gFilter, this.compFilter);
            FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.fullySupports(this.compFilter));
            FilterCapabilitiesTest.assertTrue((!this.capabilities.fullySupports(this.gFilter) ? 1 : 0) != 0);
            FilterCapabilitiesTest.assertTrue((!this.capabilities.fullySupports(this.logFilter) ? 1 : 0) != 0);
            this.logFilter = ff.and(this.compFilter, (Filter)ff.between((Expression)ff.property("sample"), (Expression)ff.literal(1), (Expression)ff.literal(2)));
            FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.or(this.logFilter, (Filter)ff.between((Expression)ff.property("sample"), (Expression)ff.literal(1), (Expression)ff.literal(2)));
            FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.and(this.logFilter, this.gFilter);
            FilterCapabilitiesTest.assertTrue((!this.capabilities.fullySupports(this.logFilter) ? 1 : 0) != 0);
        }
        catch (IllegalFilterException e) {
            LOGGER.fine("Bad filter " + (Object)((Object)e));
        }
    }
}

