/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.EnvFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Equals;

public class FilterAttributeExtractorTest
extends TestCase {
    boolean set = false;
    FilterAttributeExtractor fae;
    FilterFactory2 fac;
    TestSuite suite = null;

    public FilterAttributeExtractorTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FilterAttributeExtractorTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterAttributeExtractorTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException {
        if (this.set) {
            return;
        }
        this.set = true;
        this.fae = new FilterAttributeExtractor();
        this.fac = CommonFactoryFinder.getFilterFactory2(null);
    }

    public void testPropertyNameSet() throws IllegalFilterException {
        PropertyIsEqualTo filter = this.fac.equals((Expression)this.fac.property("testString"), (Expression)this.fac.literal((Object)"test string data"));
        PropertyName expression1 = this.fac.property("code");
        Function expression2 = this.fac.function("length", new Expression[]{this.fac.property("identification")});
        FilterAttributeExtractor extract = new FilterAttributeExtractor(null);
        HashSet names = new HashSet();
        expression1.accept((ExpressionVisitor)extract, names);
        expression2.accept((ExpressionVisitor)extract, names);
        filter.accept((FilterVisitor)extract, names);
        String[] array = extract.getAttributeNames();
        Set attributes = extract.getAttributeNameSet();
        Set properties = extract.getPropertyNameSet();
        FilterAttributeExtractorTest.assertEquals((int)3, (int)array.length);
        FilterAttributeExtractorTest.assertEquals((int)3, (int)attributes.size());
        FilterAttributeExtractorTest.assertEquals((int)3, (int)properties.size());
    }

    public void testCompare() throws IllegalFilterException {
        PropertyIsEqualTo filter = this.fac.equals((Expression)this.fac.property("testString"), (Expression)this.fac.literal((Object)"test string data"));
        this.assertAttributeName((Filter)filter, "testString");
    }

    private void assertAttributeName(Filter filter, String name) {
        this.assertAttributeName(filter, new String[]{name});
    }

    private void assertAttributeName(Filter filter, String[] names) {
        this.fae.clear();
        filter.accept((FilterVisitor)this.fae, null);
        Set attNames = this.fae.getAttributeNameSet();
        FilterAttributeExtractorTest.assertNotNull((Object)attNames);
        FilterAttributeExtractorTest.assertEquals((int)attNames.size(), (int)names.length);
        for (int i = 0; i < names.length; ++i) {
            FilterAttributeExtractorTest.assertTrue((boolean)attNames.contains(names[i]));
        }
        Set propNames = this.fae.getPropertyNameSet();
        FilterAttributeExtractorTest.assertNotNull((Object)propNames);
        FilterAttributeExtractorTest.assertEquals((int)attNames.size(), (int)propNames.size());
        for (PropertyName pn : propNames) {
            FilterAttributeExtractorTest.assertTrue((boolean)attNames.contains(pn.getPropertyName()));
        }
    }

    public void testLike() throws IllegalFilterException {
        PropertyIsLike filter = this.fac.like((Expression)this.fac.property("testString"), "abc");
        this.assertAttributeName((Filter)filter, "testString");
    }

    public void testNull() throws IllegalFilterException {
        PropertyIsNull filter = this.fac.isNull((Expression)this.fac.property("foo"));
        this.assertAttributeName((Filter)filter, new String[]{"foo"});
    }

    public void testBetween() throws IllegalFilterException {
        Literal lower = this.fac.literal(1001);
        Literal upper = this.fac.literal(1003);
        PropertyName pint = this.fac.property("testInteger");
        PropertyName plong = this.fac.property("testLong");
        PropertyName pfloat = this.fac.property("testFloat");
        this.assertAttributeName((Filter)this.fac.between((Expression)lower, (Expression)lower, (Expression)upper), new String[0]);
        this.assertAttributeName((Filter)this.fac.between((Expression)pint, (Expression)lower, (Expression)upper), "testInteger");
        this.assertAttributeName((Filter)this.fac.between((Expression)pint, (Expression)pint, (Expression)pint), "testInteger");
        this.assertAttributeName((Filter)this.fac.between((Expression)pint, (Expression)plong, (Expression)pfloat), new String[]{"testInteger", "testLong", "testFloat"});
    }

    public void testGeometry() throws IllegalFilterException {
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        PropertyName att = this.fac.property("testGeometry");
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Literal geom = this.fac.literal((Object)gf.createLineString(coords));
        Equals filter = this.fac.equal((Expression)att, (Expression)geom);
        this.assertAttributeName((Filter)filter, "testGeometry");
        filter = this.fac.equal((Expression)att, (Expression)att);
        this.assertAttributeName((Filter)filter, "testGeometry");
        filter = this.fac.equal((Expression)geom, (Expression)att);
        this.assertAttributeName((Filter)filter, "testGeometry");
    }

    public void testDistanceGeometry() throws Exception {
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(10.0, 10.0), new Coordinate(15.0, 10.0), new Coordinate(15.0, 15.0), new Coordinate(10.0, 15.0), new Coordinate(10.0, 10.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Literal right = this.fac.literal((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        DWithin filter = this.fac.dwithin((Expression)this.fac.property("testGeometry"), (Expression)right, 10.0, "m");
        this.assertAttributeName((Filter)filter, "testGeometry");
    }

    public void testFid() {
        Id filter = this.fac.id(Collections.singleton(this.fac.featureId("fakeId")));
        this.assertAttributeName((Filter)filter, new String[0]);
    }

    public void testLogic() throws IllegalFilterException {
        PropertyName testAttribute = this.fac.property("testString");
        PropertyIsEqualTo filterTrue = this.fac.equals((Expression)testAttribute, (Expression)this.fac.literal((Object)"test string data"));
        PropertyIsEqualTo filterFalse = this.fac.equals((Expression)testAttribute, (Expression)this.fac.literal((Object)"incorrect test string data"));
        Or filter = this.fac.or(Arrays.asList(filterFalse, filterTrue));
        this.assertAttributeName((Filter)filter, "testString");
    }

    public void testDynamicProperty() throws Exception {
        Function func = this.fac.function("property", new Expression[]{this.fac.function("env", new Expression[]{this.fac.literal((Object)"pname")})});
        PropertyIsEqualTo filter = this.fac.equals((Expression)func, (Expression)this.fac.literal((Object)"test"));
        try {
            EnvFunction.setLocalValue((String)"pname", (Object)"name");
            this.assertAttributeName((Filter)filter, "name");
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }
}

