/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.List;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.FeatureCalc;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;

public abstract class VisitorTestCase<T, R> {
    private final Class<T> valueClass;
    private final List<T> values;
    private final R expectedValue;
    private SimpleFeatureType featureType;
    private SimpleFeatureBuilder featureBuilder;
    ListFeatureCollection featureCollection;

    protected VisitorTestCase(Class<T> valueClass, List<T> values, R expectedValue) {
        this.valueClass = valueClass;
        this.values = values;
        this.expectedValue = expectedValue;
    }

    protected abstract FeatureCalc createVisitor(int var1, SimpleFeatureType var2);

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("test");
        ftb.add("val", this.valueClass);
        ftb.add("intVal", Integer.class);
        this.featureType = ftb.buildFeatureType();
        this.featureBuilder = new SimpleFeatureBuilder(this.featureType);
        this.featureCollection = new ListFeatureCollection(this.featureType);
    }

    @Test
    public void emptyCollection() throws Exception {
        FeatureCalc calc = this.createVisitor(0, this.featureType);
        this.featureCollection.accepts((FeatureVisitor)calc, null);
        Assert.assertNull((Object)calc.getResult().getValue());
    }

    @Test
    public void onlyNulls() throws Exception {
        this.featureCollection.add(this.featureBuilder.buildFeature("f1", new Object[]{null, 1}));
        this.featureCollection.add(this.featureBuilder.buildFeature("f2", new Object[]{null, 2}));
        this.featureCollection.add(this.featureBuilder.buildFeature("f3", new Object[]{null, 3}));
        FeatureCalc calc = this.createVisitor(0, this.featureType);
        this.featureCollection.accepts((FeatureVisitor)calc, null);
        Assert.assertNull((Object)calc.getResult().getValue());
    }

    @Test
    public void onlyNotNulls() throws Exception {
        Object value2;
        int idx = 1;
        for (Object value2 : this.values) {
            this.featureCollection.add(this.featureBuilder.buildFeature("f" + idx, new Object[]{value2, idx}));
            ++idx;
        }
        FeatureCalc calc = this.createVisitor(0, this.featureType);
        this.featureCollection.accepts((FeatureVisitor)calc, null);
        value2 = calc.getResult().getValue();
        Assert.assertEquals(this.expectedValue, value2);
        Assert.assertSame(this.expectedValue.getClass(), value2.getClass());
    }

    @Test
    public void mixed() throws Exception {
        Object value2;
        int idx = 1;
        for (Object value2 : this.values) {
            this.featureCollection.add(this.featureBuilder.buildFeature("f" + idx, new Object[]{value2, idx}));
            this.featureCollection.add(this.featureBuilder.buildFeature("f" + idx, new Object[]{null, ++idx}));
            ++idx;
        }
        FeatureCalc calc = this.createVisitor(0, this.featureType);
        this.featureCollection.accepts((FeatureVisitor)calc, null);
        value2 = calc.getResult().getValue();
        Assert.assertEquals(this.expectedValue, value2);
        Assert.assertSame(this.expectedValue.getClass(), value2.getClass());
    }
}

