/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import junit.framework.TestCase;
import org.geotools.feature.visitor.AbstractCalcResult;

public class CalcResultTest
extends TestCase {
    MockCalcResult result = new MockCalcResult();
    Integer val1 = 4;
    Long val2 = 5L;
    Float val3 = Float.valueOf(6.0f);
    Double val4 = 7.0;
    String val5 = new String("8");
    String val6 = new String("Random text of arbitrary complexity.");

    public void testInt() {
        this.result.setValue(this.val1);
        CalcResultTest.assertEquals((int)4, (int)this.result.toInt());
        this.result.setValue(this.val2);
        CalcResultTest.assertEquals((int)5, (int)this.result.toInt());
        this.result.setValue(this.val3);
        CalcResultTest.assertEquals((int)6, (int)this.result.toInt());
        this.result.setValue(this.val4);
        CalcResultTest.assertEquals((int)7, (int)this.result.toInt());
        this.result.setValue(this.val5);
        CalcResultTest.assertEquals((int)0, (int)this.result.toInt());
        this.result.setValue(this.val6);
        CalcResultTest.assertEquals((int)0, (int)this.result.toInt());
    }

    public void testLong() {
        this.result.setValue(this.val1);
        CalcResultTest.assertEquals((long)4L, (long)this.result.toLong());
        this.result.setValue(this.val2);
        CalcResultTest.assertEquals((long)5L, (long)this.result.toLong());
        this.result.setValue(this.val3);
        CalcResultTest.assertEquals((long)6L, (long)this.result.toLong());
        this.result.setValue(this.val4);
        CalcResultTest.assertEquals((long)7L, (long)this.result.toLong());
        this.result.setValue(this.val5);
        CalcResultTest.assertEquals((long)0L, (long)this.result.toLong());
        this.result.setValue(this.val6);
        CalcResultTest.assertEquals((long)0L, (long)this.result.toLong());
    }

    public void testFloat() {
        this.result.setValue(this.val1);
        CalcResultTest.assertEquals((float)4.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val2);
        CalcResultTest.assertEquals((float)5.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val3);
        CalcResultTest.assertEquals((float)6.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val4);
        CalcResultTest.assertEquals((float)7.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val5);
        CalcResultTest.assertEquals((float)0.0f, (float)this.result.toFloat(), (float)0.0f);
        this.result.setValue(this.val6);
        CalcResultTest.assertEquals((float)0.0f, (float)this.result.toFloat(), (float)0.0f);
    }

    public void testDouble() {
        this.result.setValue(this.val1);
        CalcResultTest.assertEquals((double)4.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val2);
        CalcResultTest.assertEquals((double)5.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val3);
        CalcResultTest.assertEquals((double)6.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val4);
        CalcResultTest.assertEquals((double)7.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val5);
        CalcResultTest.assertEquals((double)0.0, (double)this.result.toDouble(), (double)0.0);
        this.result.setValue(this.val6);
        CalcResultTest.assertEquals((double)0.0, (double)this.result.toDouble(), (double)0.0);
    }

    public void testString() {
        this.result.setValue(this.val1);
        CalcResultTest.assertEquals((String)"4", (String)this.result.toString());
        this.result.setValue(this.val2);
        CalcResultTest.assertEquals((String)"5", (String)this.result.toString());
        this.result.setValue(this.val3);
        CalcResultTest.assertEquals((String)"6.0", (String)this.result.toString());
        this.result.setValue(this.val4);
        CalcResultTest.assertEquals((String)"7.0", (String)this.result.toString());
        this.result.setValue(this.val5);
        CalcResultTest.assertEquals((String)"8", (String)this.result.toString());
        this.result.setValue(this.val6);
        CalcResultTest.assertEquals((String)"Random text of arbitrary complexity.", (String)this.result.toString());
    }

    public class MockCalcResult
    extends AbstractCalcResult {
        Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

