/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import java.util.Collections;
import junit.framework.TestCase;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.feature.type.SchemaImpl;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SimpleTypeBuilderTest
extends TestCase {
    static final String URI = "gopher://localhost/test";
    SimpleFeatureTypeBuilder builder;

    protected void setUp() throws Exception {
        SchemaImpl schema = new SchemaImpl("test");
        FeatureTypeFactoryImpl typeFactory = new FeatureTypeFactoryImpl();
        GeometryType pointType = typeFactory.createGeometryType((Name)new NameImpl("test", "pointType"), Point.class, null, false, false, Collections.EMPTY_LIST, null, null);
        schema.put((Object)new NameImpl("test", "pointType"), (Object)pointType);
        AttributeType intType = typeFactory.createAttributeType((Name)new NameImpl("test", "intType"), Integer.class, false, false, Collections.EMPTY_LIST, null, null);
        schema.put((Object)new NameImpl("test", "intType"), (Object)intType);
        this.builder = new SimpleFeatureTypeBuilder((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        this.builder.setBindings((Schema)schema);
    }

    public void testSanity() {
        this.builder.setName("testName");
        this.builder.setNamespaceURI("testNamespaceURI");
        this.builder.add("point", Point.class, (CoordinateReferenceSystem)null);
        this.builder.add("integer", Integer.class);
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleTypeBuilderTest.assertNotNull((Object)type);
        SimpleTypeBuilderTest.assertEquals((int)2, (int)type.getAttributeCount());
        AttributeType t = type.getType("point");
        SimpleTypeBuilderTest.assertNotNull((Object)t);
        SimpleTypeBuilderTest.assertEquals(Point.class, (Object)t.getBinding());
        t = type.getType("integer");
        SimpleTypeBuilderTest.assertNotNull((Object)t);
        SimpleTypeBuilderTest.assertEquals(Integer.class, (Object)t.getBinding());
        t = type.getGeometryDescriptor().getType();
        SimpleTypeBuilderTest.assertNotNull((Object)t);
        SimpleTypeBuilderTest.assertEquals(Point.class, (Object)t.getBinding());
    }

    public void testCRS() {
        this.builder.setName("testName");
        this.builder.setNamespaceURI("testNamespaceURI");
        this.builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.crs(null).add("point", Point.class);
        this.builder.add("point2", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.setDefaultGeometry("point");
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleTypeBuilderTest.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)type.getCoordinateReferenceSystem());
        SimpleTypeBuilderTest.assertNull((Object)type.getGeometryDescriptor().getType().getCoordinateReferenceSystem());
        SimpleTypeBuilderTest.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)((GeometryType)type.getType("point2")).getCoordinateReferenceSystem());
    }

    public void testAttributeDefaultValue() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("buggy");
        builder.nillable(false).defaultValue((Object)12).add("attrWithDefault", Integer.class);
        builder.nillable(true).defaultValue(null).add("attrWithoutDefault", Integer.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleTypeBuilderTest.assertFalse((boolean)featureType.getDescriptor("attrWithDefault").isNillable());
        SimpleTypeBuilderTest.assertEquals((Object)12, (Object)featureType.getDescriptor("attrWithDefault").getDefaultValue());
        SimpleTypeBuilderTest.assertTrue((boolean)featureType.getDescriptor("attrWithoutDefault").isNillable());
        SimpleTypeBuilderTest.assertNull((Object)featureType.getDescriptor("attrWithoutDefault").getDefaultValue());
    }

    public void testMaintainDefaultGeometryOnRetype() {
        this.builder.setName("testGeometries");
        this.builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.add("geo2", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.setDefaultGeometry("geo1");
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleFeatureType retyped = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)type, (String[])new String[]{"geo2", "geo1"});
        SimpleTypeBuilderTest.assertEquals((String)"geo1", (String)retyped.getGeometryDescriptor().getLocalName());
    }

    public void testRetypeGeometryless() {
        this.builder.setName("testGeometryless");
        this.builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.builder.add("integer", Integer.class);
        this.builder.setDefaultGeometry("geo1");
        SimpleFeatureType type = this.builder.buildFeatureType();
        SimpleFeatureType retyped = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)type, (String[])new String[]{"integer"});
        SimpleTypeBuilderTest.assertNotNull((Object)retyped);
        SimpleTypeBuilderTest.assertNull((Object)retyped.getGeometryDescriptor());
        SimpleTypeBuilderTest.assertEquals((int)1, (int)retyped.getAttributeCount());
        SimpleTypeBuilderTest.assertEquals((String)"integer", (String)((AttributeDescriptor)retyped.getAttributeDescriptors().get(0)).getLocalName());
    }

    public void testInitGeometryless() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testGeometryless");
        builder.add("integer", Integer.class);
        SimpleFeatureType type1 = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.init(type1);
        SimpleFeatureType type2 = builder.buildFeatureType();
        SimpleTypeBuilderTest.assertEquals((Object)type1, (Object)type2);
    }

    public void testMaintainDefaultGeometryOnInit() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testGeometries");
        builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("geo2", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.setDefaultGeometry("geo2");
        SimpleFeatureType type1 = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.init(type1);
        SimpleFeatureType type2 = builder.buildFeatureType();
        SimpleTypeBuilderTest.assertEquals((String)"geo2", (String)type1.getGeometryDescriptor().getLocalName());
        SimpleTypeBuilderTest.assertEquals((String)"geo2", (String)type2.getGeometryDescriptor().getLocalName());
    }

    public void testRemoveDefaultGeometryAfterInit() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("testGeometries");
        builder.add("geo1", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("geo2", Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.setDefaultGeometry("geo2");
        SimpleFeatureType type1 = builder.buildFeatureType();
        builder = new SimpleFeatureTypeBuilder();
        builder.init(type1);
        builder.remove("geo2");
        SimpleFeatureType type2 = builder.buildFeatureType();
        SimpleTypeBuilderTest.assertEquals((String)"geo2", (String)type1.getGeometryDescriptor().getLocalName());
        SimpleTypeBuilderTest.assertEquals((String)"geo1", (String)type2.getGeometryDescriptor().getLocalName());
    }
}

