/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class SimpleFeatureImplTest
extends TestCase {
    SimpleFeatureType schema;
    SimpleFeature feature;
    WKTReader wkt;

    protected void setUp() throws Exception {
        super.setUp();
        this.schema = DataUtilities.createType((String)"buildings", (String)"the_geom:Geometry,name:String,ADDRESS:String");
        this.feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{null, "ABC", "Random Road, 12"}, (String)"building.1");
        this.wkt = new WKTReader();
    }

    public void testGetProperty() {
        SimpleFeatureImplTest.assertEquals((Object)"ABC", (Object)this.feature.getProperty("name").getValue());
        SimpleFeatureImplTest.assertNull((Object)this.feature.getProperty("NOWHERE"));
        SimpleFeatureImplTest.assertEquals((int)0, (int)this.feature.getProperties("NOWHERE").size());
    }

    public void testGetPropertyNullValue() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getProperty("the_geom"));
        SimpleFeatureImplTest.assertNull((Object)this.feature.getProperty("the_geom").getValue());
    }

    public void testGeometryPropertyType() {
        SimpleFeatureImplTest.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
    }

    public void testDefaultGeometryProperty() {
        SimpleFeatureImplTest.assertTrue((String)("expected GeometryAttribute, got " + this.feature.getProperty("the_geom").getClass().getName()), (boolean)(this.feature.getProperty("the_geom") instanceof GeometryAttribute));
        GeometryAttribute defaultGeometryProperty = this.feature.getDefaultGeometryProperty();
        SimpleFeatureImplTest.assertNotNull((Object)defaultGeometryProperty);
        SimpleFeatureImplTest.assertNull((Object)defaultGeometryProperty.getValue());
        SimpleFeatureImplTest.assertNotNull((Object)defaultGeometryProperty.getDescriptor());
        SimpleFeatureImplTest.assertTrue((boolean)(defaultGeometryProperty.getDescriptor() instanceof GeometryDescriptor));
    }

    public void testGetName() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getName());
        SimpleFeatureImplTest.assertEquals((Object)this.feature.getFeatureType().getName(), (Object)this.feature.getName());
    }

    public void testGetDescriptor() {
        SimpleFeatureImplTest.assertNotNull((Object)this.feature.getDescriptor());
        SimpleFeatureImplTest.assertSame((Object)this.feature.getType(), (Object)this.feature.getDescriptor().getType());
        SimpleFeatureImplTest.assertTrue((boolean)this.feature.getDescriptor().isNillable());
        SimpleFeatureImplTest.assertEquals((int)0, (int)this.feature.getDescriptor().getMinOccurs());
        SimpleFeatureImplTest.assertEquals((int)Integer.MAX_VALUE, (int)this.feature.getDescriptor().getMaxOccurs());
    }

    public void testSetValue() {
        SimpleFeature myFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{null, null, null}, (String)"building.2");
        myFeature.setValue(this.feature.getProperties());
        for (int i = 0; i < this.feature.getAttributeCount(); ++i) {
            SimpleFeatureImplTest.assertEquals((Object)this.feature.getAttribute(i), (Object)myFeature.getAttribute(i));
        }
    }

    public void testCompare2D() throws ParseException {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(3 4)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeatureImplTest.assertEquals((Object)f1, (Object)f2);
        Assert.assertNotEquals((Object)f1, (Object)f3);
    }

    public void testCompare3D() throws ParseException {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2 15)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2 18)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeature f4 = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2 18)"), "ABC", "Random Road, 12"}, (String)"building.1");
        Assert.assertNotEquals((Object)f1, (Object)f2);
        Assert.assertNotEquals((Object)f1, (Object)f3);
        Assert.assertNotEquals((Object)f2, (Object)f3);
        SimpleFeatureImplTest.assertEquals((Object)f3, (Object)f4);
    }

    public void testUserMetadata() throws ParseException {
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])new Object[]{this.wkt.read("POINT(1 2)"), "ABC", "Random Road, 12"}, (String)"building.1");
        SimpleFeatureImplTest.assertFalse((boolean)feature.hasUserData());
        SimpleFeatureImplTest.assertNotNull((Object)feature.getUserData());
        SimpleFeatureImplTest.assertFalse((boolean)feature.hasUserData());
        feature.getUserData().put("a", "b");
        SimpleFeatureImplTest.assertTrue((boolean)feature.hasUserData());
    }
}

