/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import junit.framework.TestCase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.collection.MaxSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeatureType;

public class MaxSimpleFeatureCollectionTest
extends TestCase {
    DefaultFeatureCollection delegate;

    protected void setUp() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("foo");
        tb.add("geom", Point.class);
        tb.add("name", String.class);
        SimpleFeatureType featureType = tb.buildFeatureType();
        this.delegate = new DefaultFeatureCollection(null, featureType);
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(featureType);
        for (int i = 0; i < 10; ++i) {
            b.add((Object)new GeometryFactory().createPoint(new Coordinate((double)i, (double)i)));
            b.add((Object)String.valueOf(i));
            this.delegate.add(b.buildFeature("fid." + i));
        }
    }

    public void testSize() {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 5L);
        MaxSimpleFeatureCollectionTest.assertEquals((int)5, (int)max.size());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 7L, 5L);
        MaxSimpleFeatureCollectionTest.assertEquals((int)3, (int)max.size());
    }

    public void testIsEmpty() {
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 5L);
        MaxSimpleFeatureCollectionTest.assertFalse((boolean)max.isEmpty());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 9L, 5L);
        MaxSimpleFeatureCollectionTest.assertFalse((boolean)max.isEmpty());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 10L, 5L);
        MaxSimpleFeatureCollectionTest.assertTrue((boolean)max.isEmpty());
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 0L, 0L);
        MaxSimpleFeatureCollectionTest.assertTrue((boolean)max.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIterator() {
        int i;
        MaxSimpleFeatureCollection max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 5L);
        try (SimpleFeatureIterator it = max.features();){
            for (i = 0; i < 5; ++i) {
                MaxSimpleFeatureCollectionTest.assertTrue((boolean)it.hasNext());
                MaxSimpleFeatureCollectionTest.assertNotNull((Object)it.next());
            }
            MaxSimpleFeatureCollectionTest.assertFalse((boolean)it.hasNext());
        }
        max = new MaxSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, 7L, 5L);
        it = max.features();
        try {
            for (i = 0; i < 3; ++i) {
                MaxSimpleFeatureCollectionTest.assertTrue((boolean)it.hasNext());
                MaxSimpleFeatureCollectionTest.assertNotNull((Object)it.next());
            }
            MaxSimpleFeatureCollectionTest.assertFalse((boolean)it.hasNext());
        }
        finally {
            it.close();
        }
    }
}

