/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import org.easymock.EasyMock;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.feature.visitor.UniqueVisitor;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class DecoratingFeatureCollectionTest {
    @Test
    public void testDelegateVisitor() throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        UniqueVisitor visitor = new UniqueVisitor((Expression)ff.property("test"));
        FeatureCollection mock = (FeatureCollection)EasyMock.createMock(FeatureCollection.class);
        mock.accepts((FeatureVisitor)visitor, null);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mock});
        DecoratingFeatureCollection<FeatureType, Feature> decorator = new DecoratingFeatureCollection<FeatureType, Feature>(mock){

            protected boolean canDelegate(FeatureVisitor visitor) {
                return true;
            }
        };
        decorator.accepts((FeatureVisitor)visitor, null);
        EasyMock.verify((Object[])new Object[]{mock});
    }

    @Test
    public void testDontDelegateVisitor() throws IOException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        UniqueVisitor visitor = new UniqueVisitor((Expression)ff.property("test"));
        FeatureCollection mock = (FeatureCollection)EasyMock.createMock(FeatureCollection.class);
        SimpleFeatureIterator iterator = (SimpleFeatureIterator)EasyMock.createNiceMock(SimpleFeatureIterator.class);
        EasyMock.expect((Object)mock.features()).andReturn((Object)iterator);
        EasyMock.replay((Object[])new Object[]{mock, iterator});
        DecoratingFeatureCollection<FeatureType, Feature> decorator = new DecoratingFeatureCollection<FeatureType, Feature>(mock){

            protected boolean canDelegate(FeatureVisitor visitor) {
                return false;
            }
        };
        decorator.accepts((FeatureVisitor)visitor, null);
        EasyMock.verify((Object[])new Object[]{mock});
    }
}

