/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.geotools.feature.type.DateUtil;

public class DateUtilTest
extends TestCase {
    public void testJavaUtilDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 3, 1, 1, 15);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2007-04-01T01:15:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2007-04-01", (String)date);
    }

    public void testGEOT5353_1() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2100, 1, 28, 12, 43);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2100-02-28T12:43:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2100-02-28", (String)date);
    }

    public void testGEOT5353_2() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2100, 1, 28, 12, 0);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2100-02-28T12:00:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2100-02-28", (String)date);
    }

    public void testGEOT5353_3() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2100, 1, 28, 23, 59, 59);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2100-02-28T23:59:59", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2100-02-28", (String)date);
    }

    public void testGEOT5353_4() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2100, 2, 1, 0, 0, 0);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2100-03-01T00:00:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2100-03-01", (String)date);
    }

    public void testGEOT5353_5() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2019, 2, 1, 0, 0, 0);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2019-03-01T00:00:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2019-03-01", (String)date);
    }

    public void testGEOT5353_6() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2019, 1, 28, 12, 0);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2019-02-28T12:00:00", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2019-02-28", (String)date);
    }

    public void testGEOT5353_7() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2096, 1, 28, 23, 59, 59);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2096-02-28T23:59:59", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2096-02-28", (String)date);
    }

    public void testGEOT5353_8() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2104, 1, 28, 23, 59, 59);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2104-02-28T23:59:59", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2104-02-28", (String)date);
    }

    public void testGEOT5353_9() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2400, 1, 28, 23, 59, 59);
        Date time = cal.getTime();
        String dateTime = DateUtil.serializeDateTime((Date)time);
        DateUtilTest.assertEquals((String)"2400-02-28T23:59:59", (String)dateTime);
        String date = DateUtil.serializeDate((Date)time);
        DateUtilTest.assertEquals((String)"2400-02-28", (String)date);
    }

    public void testSqlDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 3, 1, 1, 15);
        Date time = cal.getTime();
        java.sql.Date date = new java.sql.Date(time.getTime());
        String dateTime = DateUtil.serializeSqlDate((java.sql.Date)date);
        DateUtilTest.assertEquals((String)"2007-04-01", (String)dateTime);
    }

    public void testSqlTime() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2007, 3, 1, 1, 15);
        long lngTime = cal.getTime().getTime();
        Time time = new Time(lngTime);
        String t = DateUtil.serializeSqlTime((Time)time);
        DateUtilTest.assertEquals((String)"01:15:00", (String)t);
    }
}

