/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.File;
import java.net.URI;
import java.net.URL;
import junit.framework.TestCase;
import org.geotools.data.util.URConverterFactory;
import org.geotools.util.Converter;

public class URConverterFactoryTest
extends TestCase {
    URConverterFactory f;

    protected void setUp() throws Exception {
        this.f = new URConverterFactory();
    }

    public void testStringToURL() throws Exception {
        Converter c = this.f.createConverter(String.class, URL.class, null);
        URConverterFactoryTest.assertNotNull((Object)c);
        URConverterFactoryTest.assertEquals((Object)new URL("http://foo.com"), (Object)c.convert((Object)"http://foo.com", URL.class));
        URConverterFactoryTest.assertEquals((Object)new File("/foo/bar").toURI().toURL(), (Object)c.convert((Object)"/foo/bar", URL.class));
    }

    public void testStringToURI() throws Exception {
        Converter c = this.f.createConverter(String.class, URI.class, null);
        URConverterFactoryTest.assertNotNull((Object)c);
        URConverterFactoryTest.assertEquals((Object)new URI("http://foo.com"), (Object)c.convert((Object)"http://foo.com", URI.class));
    }

    public void testURIToURL() throws Exception {
        Converter c = this.f.createConverter(URL.class, URI.class, null);
        URConverterFactoryTest.assertNotNull((Object)c);
        URConverterFactoryTest.assertEquals((Object)new URI("http://foo.com"), (Object)c.convert((Object)new URL("http://foo.com"), URI.class));
    }

    public void testURLToURI() throws Exception {
        Converter c = this.f.createConverter(URI.class, URL.class, null);
        URConverterFactoryTest.assertNotNull((Object)c);
        URConverterFactoryTest.assertEquals((Object)new URL("http://foo.com"), (Object)c.convert((Object)new URI("http://foo.com"), URL.class));
    }
}

