/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.geotools.data.util.NumericConverterFactory;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

public class NumericConverterFactoryTest
extends TestCase {
    NumericConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new NumericConverterFactory();
    }

    public void testIntegral() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert((byte)127, Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert((short)127, Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127, Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127L, Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(BigInteger.valueOf(127L), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert((byte)127, Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert((short)127, Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127, Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127L, Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(BigInteger.valueOf(127L), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert((byte)127, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert((short)127, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127L, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(BigInteger.valueOf(127L), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert((byte)127, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert((short)127, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert(127, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert(127L, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert(BigInteger.valueOf(127L), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert((byte)127, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert((short)127, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(127, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(127L, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(BigInteger.valueOf(127L), BigInteger.class));
    }

    public void testFloat() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.127f), (Object)this.convert(Float.valueOf(127.127f), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.127f), (Object)this.convert(127.127, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.127f), (Object)this.convert(new BigDecimal(127.127), Float.class));
        NumericConverterFactoryTest.assertEquals((double)127.127, (double)((Double)this.convert(Float.valueOf(127.127f), Double.class)), (double)1.0E-10);
        NumericConverterFactoryTest.assertEquals((Object)127.127, (Object)this.convert(127.127, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.127, (Object)this.convert(new BigDecimal(127.127), Double.class));
        NumericConverterFactoryTest.assertEquals((double)new BigDecimal(127.127).doubleValue(), (double)((BigDecimal)this.convert(Float.valueOf(127.127f), BigDecimal.class)).doubleValue(), (double)1.0E-10);
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal("127.127"), (Object)this.convert(127.127, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.127), (Object)this.convert(new BigDecimal(127.127), BigDecimal.class));
    }

    public void testIntegralToFloat() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert((byte)127, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert((short)127, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert(127, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert(127L, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convert(BigInteger.valueOf(127L), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert((byte)127, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert((short)127, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert(127, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert(127L, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert(BigInteger.valueOf(127L), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert((byte)127, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert((short)127, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(127, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(127L, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(BigInteger.valueOf(127L), BigDecimal.class));
    }

    public void testFloatToIntegral() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(Float.valueOf(127.127f), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127.127, Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(new BigDecimal(127.127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(Float.valueOf(127.127f), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127.127, Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(new BigDecimal(127.127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(Float.valueOf(127.127f), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(127.127, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(new BigDecimal(127.127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert(Float.valueOf(127.127f), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert(127.127, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convert(new BigDecimal(127.127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(Float.valueOf(127.127f), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(127.127, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new BigDecimal(127.127), BigInteger.class));
    }

    public void testStringToInteger() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert("127", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convert(" 127 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)3, (Object)this.convert(" 3.0 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)-3, (Object)this.convert("-3.0 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)3000, (Object)this.convert("3000.0 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)3000, (Object)this.convert("3000,0 ", Integer.class));
    }

    public void testStringToDouble() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)4.4, (Object)this.convert("4.4", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert("127", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convert(" 127 ", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)3.0, (Object)this.convert(" 3.0 ", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)-3.0, (Object)this.convert("-3.0 ", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)3000.0, (Object)this.convert("3000.0 ", Double.class));
    }

    public void testStringToNumber() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)4.4, (Object)this.convert("4.4", Number.class));
    }

    Object convert(Object source, Class target) throws Exception {
        return this.factory.createConverter(source.getClass(), target, null).convert(source, target);
    }

    public static void testIntegralHandling() {
        NumericConverterFactoryTest.assertEquals((String)"3", (String)NumericConverterFactory.toIntegral((String)"3"));
        NumericConverterFactoryTest.assertEquals((String)"3", (String)NumericConverterFactory.toIntegral((String)"3.0"));
        NumericConverterFactoryTest.assertEquals((String)"-3", (String)NumericConverterFactory.toIntegral((String)"-3"));
        NumericConverterFactoryTest.assertEquals((String)"-3", (String)NumericConverterFactory.toIntegral((String)"-3.0"));
        NumericConverterFactoryTest.assertEquals((String)"3000", (String)NumericConverterFactory.toIntegral((String)"3000.0"));
        NumericConverterFactoryTest.assertEquals((String)"3000", (String)NumericConverterFactory.toIntegral((String)"3000,0"));
    }

    Object convertSafe(Object source, Class<?> target) throws Exception {
        Hints hints = new Hints();
        hints.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)true);
        return this.factory.createConverter(source.getClass(), target, hints).convert(source, target);
    }

    public void testSafeConversion() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convertSafe((byte)127, Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe((short)128, Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128, Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128L, Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128.1, Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convertSafe((byte)127, Short.class));
        NumericConverterFactoryTest.assertEquals((Object)1111, (Object)this.convertSafe((short)1111, Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128, Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128L, Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128.1, Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)127, (Object)this.convertSafe((byte)127, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)1111, (Object)this.convertSafe((short)1111, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)12345, (Object)this.convertSafe(12345, Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128L, Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128.1, Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)127L, (Object)this.convertSafe((byte)127, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)1111L, (Object)this.convertSafe((short)1111, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)12345L, (Object)this.convertSafe(12345, Long.class));
        NumericConverterFactoryTest.assertEquals((Object)1234567L, (Object)this.convertSafe(1234567, Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128.1, Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convertSafe((byte)127, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(1111L), (Object)this.convertSafe((short)1111, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(12345L), (Object)this.convertSafe(12345, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(1234567L), (Object)this.convertSafe(1234567, BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(12345678L), (Object)this.convertSafe(BigInteger.valueOf(12345678L), BigInteger.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128.1, Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(Float.valueOf(128.1f), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)127.0, (Object)this.convertSafe((byte)127, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)1111.0, (Object)this.convertSafe((short)1111, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)12345.0, (Object)this.convertSafe(12345, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)1234567.0, (Object)this.convertSafe(1234567, Double.class));
        NumericConverterFactoryTest.assertEquals((Object)12.123456, (Object)this.convertSafe(12.123456, Double.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)12.12, (Object)this.convertSafe(Float.valueOf(12.12f), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.0f), (Object)this.convertSafe((byte)127, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(1111.0f), (Object)this.convertSafe((short)1111, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(12345.0f), (Object)this.convertSafe(12345, Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(1234567.0f), (Object)this.convertSafe(1234567, Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(12345678L), Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(128.1, Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(12.12f), (Object)this.convertSafe(Float.valueOf(12.12f), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127), (Object)this.convertSafe((byte)127, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(1111), (Object)this.convertSafe((short)1111, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(12345), (Object)this.convertSafe(12345, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(1234567), (Object)this.convertSafe(1234567, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(12345678), (Object)this.convertSafe(BigInteger.valueOf(12345678L), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(Double.valueOf(12.123456).toString()), (Object)this.convertSafe(12.123456, BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(128.1), (Object)this.convertSafe(new BigDecimal(128.1), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(Float.valueOf(12.12f).toString()), (Object)this.convertSafe(Float.valueOf(12.12f), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127), (Object)this.convertSafe("127", BigDecimal.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("127f", BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)127.123, (Object)this.convertSafe("127.123", Double.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.456.456", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)Float.valueOf(127.123f), (Object)this.convertSafe("127.123", Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.456.456", Float.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(1234567L), (Object)this.convertSafe("1234567", BigInteger.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.456", BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)54L, (Object)this.convertSafe("54", Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Long.class));
        NumericConverterFactoryTest.assertEquals((Object)54, (Object)this.convertSafe("54", Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)54, (Object)this.convertSafe("54", Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Short.class));
        NumericConverterFactoryTest.assertEquals((Object)Byte.valueOf("1"), (Object)this.convertSafe("1", Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Byte.class));
    }

    public void testPrimitiveTypes() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert(1, Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert(1, Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert(1, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert(1, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert("1", Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert("1", Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert("1", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert("1", Integer.class));
    }
}

