/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geotools.data.util.LobConverterFactory;
import org.junit.Assert;

public class LobConverterFactoryTest
extends TestCase {
    private LobConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new LobConverterFactory();
    }

    public void testBlobConversionDirect() throws Exception {
        byte[] expected = new byte[]{1, 2, 3};
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andReturn((Object)expected.length);
        EasyMock.expect((Object)blob.getBytes(1L, expected.length)).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    public void testEmptyBlobConversion() throws Exception {
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        LobConverterFactoryTest.assertEquals((int)0, (int)actual.length);
    }

    public void testTooLargeBlobConversion() throws Exception {
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andReturn((Object)0x80000000L);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        LobConverterFactoryTest.assertNull((Object)actual);
    }

    public void testBlobConversionChunkwise() throws Exception {
        byte[] expected = new byte[]{1, 2, 3};
        ByteArrayInputStream is = new ByteArrayInputStream(expected);
        Blob blob = (Blob)EasyMock.createMock(Blob.class);
        EasyMock.expect((Object)blob.length()).andThrow((Throwable)new SQLFeatureNotSupportedException());
        EasyMock.expect((Object)blob.getBinaryStream()).andReturn((Object)is);
        EasyMock.replay((Object[])new Object[]{blob});
        byte[] actual = this.convert(blob);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    public void testClobConversionDirect() throws Exception {
        String expected = "abc";
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andReturn((Object)expected.length());
        EasyMock.expect((Object)clob.getSubString(1L, expected.length())).andReturn((Object)expected);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        LobConverterFactoryTest.assertEquals((String)expected, (String)actual);
    }

    public void testEmptyClobConversion() throws Exception {
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andReturn((Object)0L);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        LobConverterFactoryTest.assertEquals((String)"", (String)actual);
    }

    public void testTooLargeClobConversion() throws Exception {
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andReturn((Object)0x80000000L);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        LobConverterFactoryTest.assertNull((Object)actual);
    }

    public void testClobConversionChunkwise() throws Exception {
        String expected = "abc";
        StringReader reader = new StringReader(expected);
        Clob clob = (Clob)EasyMock.createMock(Clob.class);
        EasyMock.expect((Object)clob.length()).andThrow((Throwable)new SQLFeatureNotSupportedException());
        EasyMock.expect((Object)clob.getCharacterStream()).andReturn((Object)reader);
        EasyMock.replay((Object[])new Object[]{clob});
        String actual = this.convert(clob);
        LobConverterFactoryTest.assertEquals((String)expected, (String)actual);
    }

    private byte[] convert(Blob blob) throws Exception {
        return (byte[])this.factory.createConverter(blob.getClass(), byte[].class, null).convert((Object)blob, byte[].class);
    }

    private String convert(Clob clob) throws Exception {
        return (String)this.factory.createConverter(clob.getClass(), String.class, null).convert((Object)clob, String.class);
    }
}

