/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLStreamHandler;
import junit.framework.TestCase;
import org.geotools.data.util.DataUrlHandler;
import org.geotools.util.Converters;

public class DataUrlHandlerTest
extends TestCase {
    public void testDataUriDecoding() throws Exception {
        URL url = new URL(null, "data:,YQo=", (URLStreamHandler)new DataUrlHandler());
        this.checkDataUrlContent(url);
    }

    private void checkDataUrlContent(URL url) throws IOException {
        InputStreamReader in = new InputStreamReader(url.openStream());
        BufferedReader reader = new BufferedReader(in);
        String data = reader.readLine();
        DataUrlHandlerTest.assertEquals((String)"a", (String)data);
    }

    public void testDataUrlConverter() throws Exception {
        String datasUrl = "data:,YQo=";
        URL url = (URL)Converters.convert((Object)datasUrl, URL.class);
        DataUrlHandlerTest.assertNotNull((Object)url);
        this.checkDataUrlContent(url);
    }

    public void testDataUrlConverterFail() throws Exception {
        String wrongUrl = "wkt://Polygon (1 1, 1 0, 0 3)";
        URL url = (URL)Converters.convert((Object)wrongUrl, URL.class);
        DataUrlHandlerTest.assertNull((Object)url);
    }
}

