/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class FilteringSimpleFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    FeatureVisitor lastVisitor = null;
    private ListFeatureCollection visitorCollection;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureType schema = DataUtilities.createType((String)"BasicPolygons", (String)"the_geom:MultiPolygon:srid=4326,ID:String,value:int");
        this.visitorCollection = new ListFeatureCollection(schema){

            public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
                FilteringSimpleFeatureCollectionTest.this.lastVisitor = visitor;
            }

            public SimpleFeatureCollection subCollection(Filter filter) {
                if (filter == Filter.INCLUDE) {
                    return this;
                }
                return super.subCollection(filter);
            }
        };
    }

    public void testNext() {
        PropertyIsEqualTo filter = this.ff.equal((Expression)this.ff.property("someAtt"), (Expression)this.ff.literal((Object)"1"), false);
        FilteringSimpleFeatureCollection collection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (Filter)filter);
        FilteringSimpleFeatureCollectionTest.assertNotNull((Object)collection.features().next());
    }

    public void testCount() {
        PropertyIsEqualTo filter = this.ff.equal((Expression)this.ff.property("someAtt"), (Expression)this.ff.literal((Object)"1"), false);
        FilteringSimpleFeatureCollection collection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (Filter)filter);
        FilteringSimpleFeatureCollectionTest.assertEquals((int)1, (int)collection.size());
    }

    public void testVisitor() throws IOException {
        PropertyIsEqualTo filter = this.ff.equal((Expression)this.ff.property("someAtt"), (Expression)this.ff.literal((Object)"1"), false);
        FilteringSimpleFeatureCollection collection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (Filter)filter);
        collection.accepts(new FeatureVisitor(){

            public void visit(Feature feature) {
                TestCase.assertEquals((Object)1, (Object)feature.getProperty("someAtt").getValue());
            }
        }, null);
    }

    @Test
    public void testMaxVisitorDelegation() throws SchemaException, IOException {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory2().property("value"));
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    @Test
    public void testCountVisitorDelegation() throws SchemaException, IOException {
        CountVisitor visitor = new CountVisitor();
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    private void assertOptimalVisit(FeatureVisitor visitor) throws IOException {
        FilteringSimpleFeatureCollection retypedCollection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.visitorCollection, (Filter)Filter.INCLUDE);
        retypedCollection.accepts(visitor, null);
        FilteringSimpleFeatureCollectionTest.assertSame((Object)this.lastVisitor, (Object)visitor);
    }
}

