/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.DecoratingDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DecoratingDataStoreTest
extends DataTestCase {
    SimpleFeatureType riverType;
    SimpleFeature[] riverFeatures;
    ReferencedEnvelope riverBounds;
    Transaction defaultTransaction = new DefaultTransaction();
    MemoryDataStore data;
    MyDecoratingDataStore decorator;

    public DecoratingDataStoreTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new MemoryDataStore();
        this.data.addFeatures(this.roadFeatures);
        this.riverType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)((DataTestCase)this).riverType, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326"));
        this.riverBounds = new ReferencedEnvelope((Envelope)((DataTestCase)this).riverBounds, CRS.decode((String)"EPSG:4326"));
        this.riverFeatures = new SimpleFeature[((DataTestCase)this).riverFeatures.length];
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            this.riverFeatures[i] = SimpleFeatureBuilder.retype((SimpleFeature)((DataTestCase)this).riverFeatures[i], (SimpleFeatureType)this.riverType);
        }
        this.data.addFeatures(this.riverFeatures);
        this.decorator = new MyDecoratingDataStore((DataStore)this.data);
    }

    protected void tearDown() throws Exception {
        this.defaultTransaction.close();
        this.data = null;
        super.tearDown();
    }

    @Test
    public void testUnwrap() {
        DecoratingDataStoreTest.assertTrue((this.decorator.unwrap(DataStore.class) == this.data ? 1 : 0) != 0);
        DecoratingDataStoreTest.assertTrue((this.decorator.unwrap(DataAccess.class) == this.data ? 1 : 0) != 0);
    }

    @Test
    public void testUnwrapWrongClass() {
        boolean error = false;
        try {
            this.decorator.unwrap(String.class);
        }
        catch (Exception e) {
            error = true;
        }
        DecoratingDataStoreTest.assertTrue((boolean)error);
    }

    @Test
    public void testDataStore() throws IOException {
        DecoratingDataStoreTest.assertEquals((int)2, (int)this.decorator.getTypeNames().length);
        SimpleFeatureSource featureSource = this.decorator.getFeatureSource(this.riverType.getTypeName());
        DecoratingDataStoreTest.assertNotNull((Object)featureSource);
        DecoratingDataStoreTest.assertEquals((int)this.riverFeatures.length, (int)featureSource.getFeatures().size());
    }

    public static class MyDecoratingDataStore
    extends DecoratingDataStore {
        public MyDecoratingDataStore(DataStore delegate) {
            super(delegate);
        }
    }
}

