/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.AbstractContentTest;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.sort.SortBy;

public class ContentFeatureSourcePagingTest
extends AbstractContentTest {
    DataStore store = new AbstractContentTest.MockContentDataStore();

    @Test
    public void defaultFeatures() throws IOException {
        Query query = new Query();
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)3L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.3", (Object)features[0].getID());
        Assert.assertEquals((Object)"mock.1", (Object)features[1].getID());
        Assert.assertEquals((Object)"mock.2", (Object)features[2].getID());
    }

    @Test
    public void naturalSortedFeatures() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)3L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.1", (Object)features[0].getID());
        Assert.assertEquals((Object)"mock.2", (Object)features[1].getID());
        Assert.assertEquals((Object)"mock.3", (Object)features[2].getID());
    }

    @Test
    public void reverseSortedFeatures() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)3L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.3", (Object)features[0].getID());
        Assert.assertEquals((Object)"mock.2", (Object)features[1].getID());
        Assert.assertEquals((Object)"mock.1", (Object)features[2].getID());
    }

    @Test
    public void oneFeatureFirstPage() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(0));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.1", (Object)features[0].getID());
    }

    @Test
    public void oneFeatureSecondPage() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(1));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.2", (Object)features[0].getID());
    }

    @Test
    public void oneFeatureThirdPage() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(2));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.3", (Object)features[0].getID());
    }

    @Test
    public void naturalSortedOneFeatureFirstPage() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(0));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.1", (Object)features[0].getID());
    }

    @Test
    public void naturalSortedOneFeatureSecondPage() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(1));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.2", (Object)features[0].getID());
    }

    @Test
    public void naturalSortedOneFeatureThirdPage() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(2));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.3", (Object)features[0].getID());
    }

    @Test
    public void reverseSortedOneFeatureFirstPage() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(0));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.3", (Object)features[0].getID());
    }

    @Test
    public void reverseSortedOneFeatureSecondPage() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(1));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.2", (Object)features[0].getID());
    }

    @Test
    public void reverseSortedOneFeatureThirdPage() throws IOException {
        Query query = new Query();
        query.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        query.setMaxFeatures(1);
        query.setStartIndex(Integer.valueOf(2));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.1", (Object)features[0].getID());
    }

    @Test
    public void twoFeaturesFirstPage() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(2);
        query.setStartIndex(Integer.valueOf(0));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)2L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.1", (Object)features[0].getID());
        Assert.assertEquals((Object)"mock.2", (Object)features[1].getID());
    }

    @Test
    public void twoFeaturesLastPage() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(2);
        query.setStartIndex(Integer.valueOf(1));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)2L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.2", (Object)features[0].getID());
        Assert.assertEquals((Object)"mock.3", (Object)features[1].getID());
    }

    @Test
    public void twoFeaturesReturnOne() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(2);
        query.setStartIndex(Integer.valueOf(2));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)1L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.3", (Object)features[0].getID());
    }

    @Test
    public void threeFeatures() throws IOException {
        Query query = new Query();
        query.setMaxFeatures(3);
        query.setStartIndex(Integer.valueOf(0));
        SimpleFeatureSource fs = this.store.getFeatureSource(TYPENAME);
        SimpleFeature[] features = (SimpleFeature[])fs.getFeatures(query).toArray();
        Assert.assertEquals((long)3L, (long)fs.getCount(query));
        Assert.assertEquals((Object)"mock.1", (Object)features[0].getID());
        Assert.assertEquals((Object)"mock.2", (Object)features[1].getID());
        Assert.assertEquals((Object)"mock.3", (Object)features[2].getID());
    }
}

