/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public abstract class AbstractContentTest {
    protected static final Name TYPENAME = new NameImpl("http://www.geotools.org", "Mock");
    protected static final SimpleFeatureType TYPE = AbstractContentTest.buildType();
    List<SimpleFeature> FEATURES = new ArrayList<SimpleFeature>(){
        {
            this.add(AbstractContentTest.buildFeature("mock.3"));
            this.add(AbstractContentTest.buildFeature("mock.1"));
            this.add(AbstractContentTest.buildFeature("mock.2"));
        }
    };

    protected static SimpleFeatureType buildType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(TYPENAME);
        builder.add("geom", LineString.class);
        return builder.buildFeatureType();
    }

    protected static SimpleFeature buildFeature(String id) {
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(TYPE);
        builder.add((Object)new Envelope(0.0, 1.0, 0.0, 1.0));
        return builder.buildFeature(id);
    }

    protected class MockSimpleFeatureWriter
    implements SimpleFeatureWriter {
        private int index = 0;
        SimpleFeature newFeature;

        protected MockSimpleFeatureWriter() {
        }

        public SimpleFeatureType getFeatureType() {
            return TYPE;
        }

        public SimpleFeature next() throws IOException {
            if (this.index >= AbstractContentTest.this.FEATURES.size()) {
                this.newFeature = AbstractContentTest.buildFeature("mock." + ++this.index);
                return this.newFeature;
            }
            return AbstractContentTest.this.FEATURES.get(this.index++);
        }

        public void remove() throws IOException {
            if (this.index > 0 && this.index <= AbstractContentTest.this.FEATURES.size()) {
                SimpleFeature simpleFeature = AbstractContentTest.this.FEATURES.remove(this.index - 1);
            }
        }

        public void write() throws IOException {
            if (this.index > AbstractContentTest.this.FEATURES.size()) {
                AbstractContentTest.this.FEATURES.add(this.newFeature);
            }
        }

        public boolean hasNext() throws IOException {
            return this.index < AbstractContentTest.this.FEATURES.size();
        }

        public void close() throws IOException {
        }
    }

    protected class MockSimpleFeatureReader
    implements SimpleFeatureReader {
        private int index = 0;

        protected MockSimpleFeatureReader() {
        }

        public SimpleFeatureType getFeatureType() {
            return TYPE;
        }

        public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
            return AbstractContentTest.this.FEATURES.get(this.index++);
        }

        public boolean hasNext() throws IOException {
            return this.index < AbstractContentTest.this.FEATURES.size();
        }

        public void close() throws IOException {
        }
    }

    protected class MockContentFeatureStore
    extends ContentFeatureStore {
        public MockContentFeatureStore(ContentEntry entry, Query query) {
            super(entry, query);
        }

        protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int getCountInternal(Query query) throws IOException {
            if (query.getFilter() == Filter.INCLUDE) {
                int count = 0;
                try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
                    while (featureReader.hasNext()) {
                        featureReader.next();
                        ++count;
                    }
                }
                return count;
            }
            return -1;
        }

        protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
            return new MockSimpleFeatureReader();
        }

        protected SimpleFeatureType buildFeatureType() throws IOException {
            return TYPE;
        }

        protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
            return new MockSimpleFeatureWriter();
        }
    }

    protected class MockContentDataStore
    extends ContentDataStore {
        protected MockContentDataStore() {
            this.namespaceURI = TYPE.getName().getNamespaceURI();
        }

        protected List<Name> createTypeNames() throws IOException {
            return new ArrayList<Name>(){
                {
                    this.add(TYPENAME);
                }
            };
        }

        protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
            return new MockContentFeatureStore(entry, null);
        }
    }
}

