/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.FilteredIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;

public class MemoryFeatureCollectionTest
extends DataTestCase {
    private MemoryFeatureCollection roads;

    public MemoryFeatureCollectionTest(String test) {
        super(test);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.roads = new MemoryFeatureCollection(this.roadType);
        this.roads.addAll(Arrays.asList(this.roadFeatures));
    }

    public void testAdd() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            rivers.add(this.riverFeatures[i]);
        }
        MemoryFeatureCollectionTest.assertEquals((int)this.riverFeatures.length, (int)rivers.size());
    }

    public void testAddAll() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        rivers.addAll(Arrays.asList(this.riverFeatures));
    }

    public void testSize() {
        MemoryFeatureCollectionTest.assertEquals((int)this.roadFeatures.length, (int)this.roads.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResources() {
        Object[] array = this.roads.toArray();
        MemoryFeatureCollectionTest.assertEquals((int)this.roads.size(), (int)array.length);
        try (SimpleFeatureIterator i = this.roads.features();){
            MemoryFeatureCollectionTest.assertTrue((boolean)i.hasNext());
        }
        try {
            MemoryFeatureCollectionTest.assertFalse((boolean)i.hasNext());
            MemoryFeatureCollectionTest.fail((String)"should be closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        i = this.roads.features();
        try {
            MemoryFeatureCollectionTest.assertTrue((boolean)i.hasNext());
        }
        finally {
            i.close();
        }
        try {
            MemoryFeatureCollectionTest.assertFalse((boolean)i.hasNext());
            MemoryFeatureCollectionTest.fail((String)"should be closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBounds() {
        MemoryFeatureCollection rivers = new MemoryFeatureCollection(this.riverType);
        ReferencedEnvelope expected = new ReferencedEnvelope();
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            rivers.add(this.riverFeatures[i]);
            expected.include(this.riverFeatures[i].getBounds());
        }
        MemoryFeatureCollectionTest.assertEquals((int)this.riverFeatures.length, (int)rivers.size());
        MemoryFeatureCollectionTest.assertNotNull((Object)rivers.getBounds());
        MemoryFeatureCollectionTest.assertEquals((Object)expected, (Object)rivers.getBounds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIterator() throws Exception {
        int count = 0;
        Iterator it = this.roads.iterator();
        try {
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                ++count;
            }
        }
        finally {
            DataUtilities.close((Iterator)it);
        }
        MemoryFeatureCollectionTest.assertEquals((int)this.roads.size(), (int)count);
        count = 0;
        try (FilteredIterator filteredIterator = new FilteredIterator((Collection)this.roads, this.rd12Filter);){
            while (filteredIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)filteredIterator.next();
                ++count;
            }
        }
        MemoryFeatureCollectionTest.assertEquals((int)this.expected(this.rd12Filter), (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubCollection() {
        int count = 0;
        try (SimpleFeatureIterator it = this.roads.features();){
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                if (!this.rd12Filter.evaluate((Object)feature)) continue;
                ++count;
            }
        }
        SimpleFeatureCollection sub = this.roads.subCollection(this.rd12Filter);
        MemoryFeatureCollectionTest.assertEquals((int)count, (int)sub.size());
    }

    public void testSubSubCollection() {
        SimpleFeatureCollection sub = this.roads.subCollection(this.rd12Filter);
        SimpleFeatureCollection subsub = sub.subCollection(this.rd1Filter);
        MemoryFeatureCollectionTest.assertEquals((int)1, (int)subsub.size());
    }

    public void XtestSort() {
    }
}

