/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureReaderTest
extends TestCase {
    private static final String FEATURE_TYPE_NAME = "testType";

    protected void setUp() throws Exception {
        super.setUp();
    }

    private SimpleFeatureCollection createTestFeatureCollection(CoordinateReferenceSystem crs, Point p) throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(crs);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        ListFeatureCollection features = new ListFeatureCollection(ft);
        features.add(b.buildFeature(null));
        return features;
    }

    public void testSameCRS() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection features = this.createTestFeatureCollection((CoordinateReferenceSystem)crs, p);
        SimpleFeatureReader original = DataUtilities.reader((FeatureCollection)features);
        try (ForceCoordinateSystemFeatureReader modified = new ForceCoordinateSystemFeatureReader((FeatureReader)DataUtilities.reader((FeatureCollection)features), (CoordinateReferenceSystem)crs);){
            SimpleFeature f1 = (SimpleFeature)original.next();
            SimpleFeature f2 = modified.next();
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)f1, (Object)f2);
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)original.hasNext());
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)modified.hasNext());
            ForceCoordinateSystemFeatureReaderTest.assertSame((Object)modified.builder.getFeatureType(), (Object)original.getFeatureType());
        }
    }

    public void testDifferentCRS() throws Exception {
        DefaultGeographicCRS srcCRS = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection features = this.createTestFeatureCollection((CoordinateReferenceSystem)srcCRS, p);
        SimpleFeatureReader original = DataUtilities.reader((FeatureCollection)features);
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        try (ForceCoordinateSystemFeatureReader modified = new ForceCoordinateSystemFeatureReader((FeatureReader)DataUtilities.reader((FeatureCollection)features), (CoordinateReferenceSystem)destCRS);){
            SimpleFeature f1 = (SimpleFeature)original.next();
            SimpleFeature f2 = modified.next();
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
            SimpleFeatureType f1Type = f1.getFeatureType();
            SimpleFeatureType f2Type = f2.getFeatureType();
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)f1Type.getCoordinateReferenceSystem().equals(f2Type.getCoordinateReferenceSystem()));
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)srcCRS, (Object)f1Type.getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)srcCRS, (Object)f1Type.getGeometryDescriptor().getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getGeometryDescriptor().getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)original.hasNext());
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)modified.hasNext());
            ForceCoordinateSystemFeatureReaderTest.assertNotNull((Object)modified.builder);
        }
    }

    public void testNullDestination() throws Exception {
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection features = this.createTestFeatureCollection((CoordinateReferenceSystem)crs, p);
        try {
            new ForceCoordinateSystemFeatureReader((FeatureReader)DataUtilities.reader((FeatureCollection)features), (CoordinateReferenceSystem)null);
            ForceCoordinateSystemFeatureReaderTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testNullSource() throws Exception {
        CoordinateReferenceSystem srcCRS = null;
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureCollection features = this.createTestFeatureCollection(srcCRS, p);
        SimpleFeatureReader original = DataUtilities.reader((FeatureCollection)features);
        DefaultEngineeringCRS destCRS = DefaultEngineeringCRS.CARTESIAN_2D;
        try (ForceCoordinateSystemFeatureReader modified = new ForceCoordinateSystemFeatureReader((FeatureReader)DataUtilities.reader((FeatureCollection)features), (CoordinateReferenceSystem)destCRS);){
            SimpleFeature f1 = (SimpleFeature)original.next();
            SimpleFeature f2 = modified.next();
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)((Geometry)f1.getDefaultGeometry()).getCoordinate(), (Object)((Geometry)f2.getDefaultGeometry()).getCoordinate());
            SimpleFeatureType f1Type = f1.getFeatureType();
            SimpleFeatureType f2Type = f2.getFeatureType();
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)f2Type.getCoordinateReferenceSystem().equals(f1Type.getCoordinateReferenceSystem()));
            ForceCoordinateSystemFeatureReaderTest.assertEquals(srcCRS, (Object)f1Type.getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertEquals(srcCRS, (Object)f1Type.getGeometryDescriptor().getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertEquals((Object)destCRS, (Object)f2Type.getGeometryDescriptor().getCoordinateReferenceSystem());
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)original.hasNext());
            ForceCoordinateSystemFeatureReaderTest.assertFalse((boolean)modified.hasNext());
            ForceCoordinateSystemFeatureReaderTest.assertNotNull((Object)modified.builder);
        }
    }
}

