/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class ForceCoordinateFeatureResultsTest
extends TestCase {
    private static final String FEATURE_TYPE_NAME = "testType";
    private CoordinateReferenceSystem wgs84;
    private CoordinateReferenceSystem utm32n;
    private ListFeatureCollection featureCollection;
    FeatureVisitor lastVisitor = null;
    private ListFeatureCollection visitorCollection;

    protected void setUp() throws Exception {
        this.lastVisitor = null;
        this.wgs84 = CRS.decode((String)"EPSG:4326");
        this.utm32n = CRS.decode((String)"EPSG:32632");
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(this.wgs84);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        this.featureCollection = new ListFeatureCollection(ft);
        this.featureCollection.add(b.buildFeature(null));
        this.visitorCollection = new ListFeatureCollection(ft){

            public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
                ForceCoordinateFeatureResultsTest.this.lastVisitor = visitor;
            }

            public SimpleFeatureCollection subCollection(Filter filter) {
                if (filter == Filter.INCLUDE) {
                    return this;
                }
                return super.subCollection(filter);
            }
        };
    }

    public void testSchema() throws Exception {
        ListFeatureCollection original = this.featureCollection;
        ForceCoordinateFeatureResultsTest.assertEquals((Object)this.wgs84, (Object)((SimpleFeatureType)original.getSchema()).getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureResults forced = new ForceCoordinateSystemFeatureResults((FeatureCollection)original, this.utm32n);
        ForceCoordinateFeatureResultsTest.assertEquals((Object)this.utm32n, (Object)((SimpleFeatureType)forced.getSchema()).getCoordinateReferenceSystem());
    }

    public void testBounds() throws Exception {
        ListFeatureCollection original = this.featureCollection;
        ForceCoordinateFeatureResultsTest.assertFalse((boolean)original.getBounds().isEmpty());
        ForceCoordinateSystemFeatureResults forced = new ForceCoordinateSystemFeatureResults((FeatureCollection)original, this.utm32n);
        ForceCoordinateFeatureResultsTest.assertEquals((Object)new ReferencedEnvelope(10.0, 10.0, 10.0, 10.0, this.utm32n), (Object)forced.getBounds());
    }

    public void testMaxVisitorDelegation() throws SchemaException, IOException {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory2().property("value"));
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    public void testCountVisitorDelegation() throws SchemaException, IOException {
        CountVisitor visitor = new CountVisitor();
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    private void assertOptimalVisit(FeatureVisitor visitor) throws IOException, SchemaException {
        ForceCoordinateSystemFeatureResults retypedCollection = new ForceCoordinateSystemFeatureResults((FeatureCollection)this.visitorCollection, this.utm32n);
        retypedCollection.accepts(visitor, null);
        ForceCoordinateFeatureResultsTest.assertSame((Object)this.lastVisitor, (Object)visitor);
    }

    public void testBoundsNotOptimized() throws IOException, SchemaException {
        BoundsVisitor boundsVisitor = new BoundsVisitor();
        ForceCoordinateSystemFeatureResults retypedCollection = new ForceCoordinateSystemFeatureResults((FeatureCollection)this.visitorCollection, this.utm32n);
        retypedCollection.accepts((FeatureVisitor)boundsVisitor, null);
        ForceCoordinateFeatureResultsTest.assertNull((Object)this.lastVisitor);
    }
}

