/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class TransactionTest
extends TestCase {
    MemoryDataStore ds;
    SimpleFeatureType type;
    Geometry geom;

    protected void setUp() throws Exception {
        super.setUp();
        this.type = DataUtilities.createType((String)"default", (String)"name:String,*geom:Geometry");
        GeometryFactory fac = new GeometryFactory();
        this.geom = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"original", this.geom}, null);
        this.ds = new MemoryDataStore(new SimpleFeature[]{f1});
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddFeature() throws Exception {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"one", this.geom}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"two", this.geom}, null);
        SimpleFeatureStore store = (SimpleFeatureStore)this.ds.getFeatureSource("default");
        store.setTransaction((Transaction)new DefaultTransaction());
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f1));
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f2));
        this.count(store, 3);
    }

    public void testRemoveFeature() throws Exception {
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)this.type, (Object[])new Object[]{"one", this.geom}, null);
        SimpleFeatureStore store = (SimpleFeatureStore)this.ds.getFeatureSource("default");
        store.setTransaction((Transaction)new DefaultTransaction());
        List fid = store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)f1));
        this.count(store, 2);
        FeatureId identifier = (FeatureId)fid.iterator().next();
        String next = identifier.getID();
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        Id f = filterFactory.id(Collections.singleton(filterFactory.featureId(next)));
        store.removeFeatures((Filter)f);
        this.count(store, 1);
    }

    private void count(SimpleFeatureStore store, int expected) throws IOException, IllegalAttributeException {
        int i = 0;
        SimpleFeatureIterator reader = store.getFeatures().features();
        while (reader.hasNext()) {
            reader.next();
            ++i;
        }
        TransactionTest.assertEquals((String)"Number of known feature as obtained from reader", (int)expected, (int)i);
    }
}

