/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.xml.sax.helpers.NamespaceSupport;

public class QueryTest
extends TestCase {
    public QueryTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(QueryTest.class);
        return suite;
    }

    public void testFullConstructor() {
        Query query = new Query("mytype", (Filter)Filter.INCLUDE, 10, new String[]{"foo"}, "myquery");
        QueryTest.assertNotNull((Object)query);
    }

    public void testPropertyNames() {
        Query query = new Query();
        QueryTest.assertNull((Object)query.getPropertyNames());
        query.setPropertyNames(new String[]{"foo", "bar"});
        String[] names = query.getPropertyNames();
        QueryTest.assertNotNull((Object)names);
        QueryTest.assertEquals((String)"foo", (String)names[0]);
        List<String> list = Arrays.asList(names);
        query.setPropertyNames(list);
        names = query.getPropertyNames();
        QueryTest.assertEquals((String)"bar", (String)names[1]);
        List properties2 = query.getProperties();
        QueryTest.assertNotNull((Object)properties2);
        QueryTest.assertEquals((String)"foo", (String)((PropertyName)properties2.get(0)).getPropertyName());
        QueryTest.assertEquals((String)"bar", (String)((PropertyName)properties2.get(1)).getPropertyName());
        query.setPropertyNames(Query.ALL_NAMES);
        QueryTest.assertNull((Object)query.getPropertyNames());
        query = new Query("Test", (Filter)Filter.INCLUDE, new String[]{"foo", "wibble"});
        QueryTest.assertNotNull((Object)query.getPropertyNames());
    }

    public void testProperties() {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Query query = new Query();
        QueryTest.assertNull((Object)query.getProperties());
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        NamespaceSupport nsContext = new NamespaceSupport();
        nsContext.declarePrefix("foo", "FooNamespace");
        PropertyName fooProp = ff.property("foo", nsContext);
        PropertyName barProp = ff.property("bar", nsContext);
        properties.add(fooProp);
        properties.add(barProp);
        query.setProperties(properties);
        List properties2 = query.getProperties();
        QueryTest.assertNotNull(properties);
        QueryTest.assertEquals((Object)fooProp, properties2.get(0));
        QueryTest.assertEquals((Object)barProp, properties2.get(1));
        QueryTest.assertEquals((Object)nsContext, (Object)((PropertyName)properties2.get(0)).getNamespaceContext());
        String[] names = query.getPropertyNames();
        QueryTest.assertEquals((String)"foo", (String)names[0]);
        QueryTest.assertEquals((String)"bar", (String)names[1]);
        query.setProperties(Query.ALL_PROPERTIES);
        QueryTest.assertNull((Object)query.getProperties());
        query = new Query("Test", (Filter)Filter.INCLUDE, properties);
        QueryTest.assertNotNull((Object)query.getProperties());
    }

    public void testRetrieveAllProperties() {
        Query query = new Query();
        QueryTest.assertTrue((boolean)query.retrieveAllProperties());
        query.setPropertyNames(new String[]{"foo", "bar"});
        QueryTest.assertFalse((boolean)query.retrieveAllProperties());
        query.setPropertyNames(Query.ALL_NAMES);
        QueryTest.assertTrue((boolean)query.retrieveAllProperties());
        query.setProperties(Query.ALL_PROPERTIES);
        QueryTest.assertTrue((boolean)query.retrieveAllProperties());
        query.setPropertyNames(new String[]{"foo", "bar"});
        query.setProperties(Query.ALL_PROPERTIES);
        QueryTest.assertTrue((boolean)query.retrieveAllProperties());
    }

    public void testMaxFeatures() {
        Query query = new Query();
        QueryTest.assertEquals((int)Integer.MAX_VALUE, (int)query.getMaxFeatures());
        query.setMaxFeatures(5);
        QueryTest.assertEquals((int)5, (int)query.getMaxFeatures());
    }

    public void testFilter() {
        Query query = new Query();
        query.setFilter((Filter)Filter.EXCLUDE);
        QueryTest.assertEquals((Object)Filter.EXCLUDE, (Object)query.getFilter());
        query = new Query("test", (Filter)Filter.INCLUDE);
        QueryTest.assertEquals((Object)Filter.INCLUDE, (Object)query.getFilter());
    }

    public void testTypeName() {
        Query query = new Query();
        QueryTest.assertNull((Object)query.getTypeName());
        query.setTypeName("foobar");
        QueryTest.assertEquals((String)"foobar", (String)query.getTypeName());
        query = new Query("mytype", (Filter)Filter.EXCLUDE);
        QueryTest.assertEquals((String)"mytype", (String)query.getTypeName());
    }

    public void testHandle() {
        Query query = new Query();
        QueryTest.assertNull((Object)query.getHandle());
        query.setHandle("myquery");
        QueryTest.assertEquals((String)"myquery", (String)query.getHandle());
    }

    public void testVersion() {
        Query query = new Query();
        QueryTest.assertNull((Object)query.getVersion());
    }

    public void testToString() {
        Query query = new Query();
        QueryTest.assertNotNull((Object)query.toString());
        query.setHandle("myquery");
        QueryTest.assertNotNull((Object)query.toString());
        query.setFilter((Filter)Filter.EXCLUDE);
        QueryTest.assertNotNull((Object)query.toString());
        query.setPropertyNames(new String[]{"foo", "bar"});
        QueryTest.assertNotNull((Object)query.toString());
        query = new Query();
        query.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        QueryTest.assertTrue((boolean)query.toString().contains("[sort by: NATURAL]"));
        query.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        QueryTest.assertTrue((boolean)query.toString().contains("[sort by: REVERSE]"));
    }

    public void testSortByEquality() {
        Query q1 = new Query();
        Query q2 = new Query();
        q2.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        MatcherAssert.assertThat((Object)q1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)q2)));
        Query q3 = new Query();
        q3.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        MatcherAssert.assertThat((Object)q2, (Matcher)CoreMatchers.equalTo((Object)q3));
    }
}

