/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class FilteringFeatureReaderTest
extends DataTestCase {
    FeatureReader<SimpleFeatureType, SimpleFeature> roadReader;
    FeatureReader<SimpleFeatureType, SimpleFeature> riverReader;

    public FilteringFeatureReaderTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.roadReader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        this.riverReader = DataUtilities.reader((SimpleFeature[])this.riverFeatures);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.roadReader.close();
        this.roadReader = null;
        this.riverReader.close();
        this.riverReader = null;
    }

    public void testFilteringFeatureReaderALL() throws IOException {
        try (FilteringFeatureReader reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.EXCLUDE);){
            FilteringFeatureReaderTest.assertFalse((boolean)reader.hasNext());
        }
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.EXCLUDE);
        FilteringFeatureReaderTest.assertEquals((int)0, (int)this.count((FeatureReader)reader));
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.EXCLUDE);
        this.assertContents(new SimpleFeature[0], (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
    }

    public void testFilteringFeatureReaderNONE() throws IOException {
        try (FilteringFeatureReader reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.INCLUDE);){
            FilteringFeatureReaderTest.assertTrue((boolean)reader.hasNext());
        }
        reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        FilteringFeatureReaderTest.assertEquals((int)this.roadFeatures.length, (int)this.count((FeatureReader)reader));
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.INCLUDE);
        FilteringFeatureReaderTest.assertEquals((int)this.roadFeatures.length, (int)this.count((FeatureReader)reader));
        reader = new FilteringFeatureReader(DataUtilities.reader((SimpleFeature[])this.roadFeatures), (Filter)Filter.INCLUDE);
        this.assertContents(this.roadFeatures, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
    }

    void assertContents(SimpleFeature[] expected, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        FilteringFeatureReaderTest.assertNotNull(reader);
        FilteringFeatureReaderTest.assertNotNull((Object)expected);
        int count = 0;
        try {
            for (int i = 0; i < expected.length; ++i) {
                FilteringFeatureReaderTest.assertTrue((boolean)reader.hasNext());
                SimpleFeature feature = (SimpleFeature)reader.next();
                FilteringFeatureReaderTest.assertNotNull((Object)feature);
                FilteringFeatureReaderTest.assertEquals((Object)expected[i], (Object)feature);
                ++count;
            }
            FilteringFeatureReaderTest.assertFalse((boolean)reader.hasNext());
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("hasNext() lied to me at:" + count, (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("next() could not understand feature at:" + count, (Throwable)e);
        }
        finally {
            reader.close();
        }
    }

    public void testNext() {
    }

    public void testClose() {
    }

    public void testGetFeatureType() {
    }

    public void testHasNext() {
    }
}

