/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DataUtilitiesTest
extends DataTestCase {
    public DataUtilitiesTest(String arg0) {
        super(arg0);
    }

    public void testSimpleCollection() {
        SimpleFeatureCollection featureCollection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeatureCollection simple = DataUtilities.simple((FeatureCollection)featureCollection);
        DataUtilitiesTest.assertSame((Object)simple, (Object)featureCollection);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)featureCollection.size());
    }

    public void testSimpleCollectionList() {
        SimpleFeatureCollection featureCollection = DataUtilities.collection(Arrays.asList(this.roadFeatures));
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)featureCollection.size());
    }

    public void testSimpleSource() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeatureSource source = DataUtilities.source((FeatureCollection)collection);
        SimpleFeatureSource simple = DataUtilities.simple((FeatureSource)source);
        DataUtilitiesTest.assertSame((Object)simple, (Object)source);
    }

    public void testSimpleType() throws DataSourceException {
        SimpleFeatureType simpleFeatureType = DataUtilities.simple((FeatureType)FakeTypes.Mine.MINETYPE_TYPE);
        DataUtilitiesTest.assertEquals(null, (Object)simpleFeatureType.getGeometryDescriptor());
    }

    public void testDataStore() throws IOException {
        SimpleFeatureSource features = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        Name name = features.getName();
        String typeName = name.getLocalPart();
        DataStore store = DataUtilities.dataStore((SimpleFeatureSource)features);
        DataUtilitiesTest.assertSame((Object)features.getSchema(), (Object)store.getSchema(name));
        DataUtilitiesTest.assertSame((Object)features.getSchema(), (Object)store.getSchema(typeName));
        DataUtilitiesTest.assertSame((Object)features, (Object)store.getFeatureSource(name));
        DataUtilitiesTest.assertSame((Object)features, (Object)store.getFeatureSource(typeName));
        DataUtilitiesTest.assertEquals((Object)name, store.getNames().get(0));
        DataUtilitiesTest.assertEquals((String)typeName, (String)store.getTypeNames()[0]);
    }

    public void testFirst() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)collection);
        DataUtilitiesTest.assertNotNull((Object)first);
        DataUtilitiesTest.assertEquals((String)"road.rd1", (String)first.getID());
    }

    public void testCheckDirectory() {
        File home = new File(System.getProperty("user.home"));
        File file = DataUtilities.checkDirectory((File)home);
        DataUtilitiesTest.assertNotNull((Object)file);
        File missing = new File(home, ".missing");
        try {
            File found = DataUtilities.checkDirectory((File)missing);
            DataUtilitiesTest.assertNull((Object)found);
            DataUtilitiesTest.fail((String)"Missing should not be found");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testReadable() {
        File home = new File(System.getProperty("user.home"));
        DataUtilitiesTest.assertFalse((String)"Home is not a readable file", (boolean)DataUtilities.checkFileReadable((File)home, null));
        FilenameFilter findFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File target = new File(dir, name);
                return target.isFile() && target.canRead();
            }
        };
        File[] readable = home.listFiles(findFilter);
        if (readable.length > 0) {
            File test = readable[0];
            DataUtilitiesTest.assertTrue((String)test.toString(), (boolean)DataUtilities.checkFileReadable((File)test, null));
        }
    }

    public void testFilters() {
        File home = new File(System.getProperty("user.home"));
        FilenameFilter directoryFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File target = new File(dir, name);
                return target.isDirectory();
            }
        };
        FilenameFilter hiddenFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File target = new File(dir, name);
                return target.isHidden();
            }
        };
        List<String> dir = Arrays.asList(home.list(directoryFilter));
        List<String> hidden = Arrays.asList(home.list(hiddenFilter));
        FilenameFilter includeFilter = DataUtilities.includeFilters((FilenameFilter)directoryFilter, (FilenameFilter[])new FilenameFilter[]{hiddenFilter});
        List<String> include = Arrays.asList(home.list(includeFilter));
        HashSet<String> both = new HashSet<String>();
        both.addAll(dir);
        both.addAll(hidden);
        DataUtilitiesTest.assertEquals((int)both.size(), (int)include.size());
        FilenameFilter excludeFilter = DataUtilities.excludeFilters((FilenameFilter)directoryFilter, (FilenameFilter[])new FilenameFilter[]{hiddenFilter});
        List<String> exclude = Arrays.asList(home.list(excludeFilter));
        HashSet<String> subtract = new HashSet<String>(dir);
        subtract.removeAll(hidden);
        DataUtilitiesTest.assertEquals((int)subtract.size(), (int)exclude.size());
    }

    public void testAttributeNamesFeatureType() {
        String[] names = DataUtilities.attributeNames((SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)4, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"id", (String)names[0]);
        DataUtilitiesTest.assertEquals((String)"geom", (String)names[1]);
        DataUtilitiesTest.assertEquals((String)"name", (String)names[2]);
        DataUtilitiesTest.assertEquals((String)"uuid", (String)names[3]);
        names = DataUtilities.attributeNames((SimpleFeatureType)this.subRoadType);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"id", (String)names[0]);
        DataUtilitiesTest.assertEquals((String)"geom", (String)names[1]);
    }

    public void testAttributeNamesFilter() throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Filter filter = null;
        String[] names = DataUtilities.attributeNames(filter);
        DataUtilitiesTest.assertEquals((int)names.length, (int)0);
        Id fidFilter = factory.id(Collections.singleton(factory.featureId("fid")));
        names = DataUtilities.attributeNames((Filter)fidFilter);
        DataUtilitiesTest.assertEquals((int)0, (int)names.length);
        PropertyName id = factory.property("id");
        PropertyName name = factory.property("name");
        PropertyName geom = factory.property("geom");
        PropertyIsNull nullFilter = factory.isNull((Expression)id);
        names = DataUtilities.attributeNames((Filter)nullFilter);
        DataUtilitiesTest.assertEquals((int)1, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"id", (String)names[0]);
        PropertyIsEqualTo equal = factory.equals((Expression)name, (Expression)id);
        names = DataUtilities.attributeNames((Filter)equal);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        List<String> list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        Function fnCall = factory.function("Max", new Expression[]{id, name});
        PropertyIsLike fn = factory.like((Expression)fnCall, "does-not-matter");
        names = DataUtilities.attributeNames((Filter)fn);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        PropertyIsBetween between = factory.between((Expression)name, (Expression)id, (Expression)geom);
        names = DataUtilities.attributeNames((Filter)between);
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("geom"));
        PropertyIsNull geomNull = factory.isNull((Expression)geom);
        names = DataUtilities.attributeNames((Filter)factory.and((Filter)geomNull, (Filter)equal));
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("geom"));
        names = DataUtilities.attributeNames((Filter)factory.not((Filter)geomNull));
        DataUtilitiesTest.assertEquals((int)1, (int)names.length);
        DataUtilitiesTest.assertEquals((String)"geom", (String)names[0]);
        PropertyIsEqualTo equalToWithPrefix = factory.equals((Expression)factory.property("gml:name"), (Expression)id);
        names = DataUtilities.attributeNames((Filter)equalToWithPrefix, (SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        list = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)list.contains("name"));
        DataUtilitiesTest.assertTrue((boolean)list.contains("id"));
    }

    public void testAttributeNamesFilterFeatureType() {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        PropertyIsEqualTo filter = factory.equals((Expression)factory.property("id"), (Expression)factory.add((Expression)factory.property("geom"), (Expression)factory.property("gml:name")));
        String[] names = DataUtilities.attributeNames((Filter)filter, (SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)3, (int)names.length);
        List<String> namesList = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("id"));
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("geom"));
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("name"));
    }

    public void testAttributeExpressionFilterFeatureType() {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        Add expression = factory.add((Expression)factory.property("geom"), (Expression)factory.property("gml:name"));
        String[] names = DataUtilities.attributeNames((Expression)expression, (SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertEquals((int)2, (int)names.length);
        List<String> namesList = Arrays.asList(names);
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("geom"));
        DataUtilitiesTest.assertTrue((boolean)namesList.contains("name"));
    }

    public void testCompare() throws SchemaException {
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compare(null, null));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)this.roadType, null));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare(null, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)this.riverType, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.riverType));
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compare((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compare((SimpleFeatureType)this.subRoadType, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road2 = DataUtilities.createType((String)"namespace.road", (String)"geom:LineString,name:String,id:0");
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compare((SimpleFeatureType)road2, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road3 = DataUtilities.createType((String)"test.road", (String)"id:0,geom:LineString,name:String,uuid:UUID");
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compare((SimpleFeatureType)road3, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road4 = DataUtilities.createType((String)"road", (String)"id:0,geom:LineString,name:String,uuid:String");
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compare((SimpleFeatureType)road4, (SimpleFeatureType)this.roadType));
    }

    public void testCompareNames() throws SchemaException {
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compareNames(null, null));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compareNames((SimpleFeatureType)this.roadType, null));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compareNames(null, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compareNames((SimpleFeatureType)this.riverType, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)-1, (int)DataUtilities.compareNames((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.riverType));
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compareNames((SimpleFeatureType)this.roadType, (SimpleFeatureType)this.roadType));
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compareNames((SimpleFeatureType)this.subRoadType, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road2 = DataUtilities.createType((String)"namespace.road", (String)"geom:LineString,name:String,id:0");
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compareNames((SimpleFeatureType)road2, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road3 = DataUtilities.createType((String)"test.road", (String)"id:0,geom:LineString,name:String,uuid:UUID");
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compareNames((SimpleFeatureType)road3, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road4 = DataUtilities.createType((String)"road", (String)"id:0,geom:LineString,name:String,uuid:String");
        DataUtilitiesTest.assertEquals((int)0, (int)DataUtilities.compareNames((SimpleFeatureType)road4, (SimpleFeatureType)this.roadType));
        SimpleFeatureType road5 = DataUtilities.createType((String)"road", (String)"id:0,uuid:String,geom:LineString,name:String");
        DataUtilitiesTest.assertEquals((int)1, (int)DataUtilities.compareNames((SimpleFeatureType)road5, (SimpleFeatureType)this.roadType));
    }

    public void testIsMatch() throws SchemaException {
        SimpleFeatureType roadType1 = DataUtilities.createType((String)"road", (String)"id:0,geom:LineString,name:String,uuid:String");
        DataUtilitiesTest.assertEquals((boolean)false, (boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("uuid"), (AttributeDescriptor)roadType1.getDescriptor("uuid")));
        DataUtilitiesTest.assertEquals((boolean)true, (boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("uuid"), (AttributeDescriptor)roadType1.getDescriptor("uuid"), (boolean)false));
        SimpleFeatureType roadType2 = DataUtilities.createType((String)"road", (String)"id:0,the_geom:LineString,name:String,uuid:UUID");
        DataUtilitiesTest.assertEquals((boolean)false, (boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType2.getDescriptor("the_geom")));
        DataUtilitiesTest.assertEquals((boolean)false, (boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType2.getDescriptor("the_geom"), (boolean)false));
        SimpleFeatureType roadType3 = DataUtilities.createType((String)"road", (String)"id:0,the_geom:LineString,geom:String,name:String,uuid:UUID");
        DataUtilitiesTest.assertEquals((boolean)false, (boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType3.getDescriptor("geom")));
        DataUtilitiesTest.assertEquals((boolean)true, (boolean)DataUtilities.isMatch((AttributeDescriptor)this.roadType.getDescriptor("geom"), (AttributeDescriptor)roadType3.getDescriptor("geom"), (boolean)false));
    }

    public void testReType() throws Exception {
        SimpleFeature rd1 = this.roadFeatures[0];
        DataUtilitiesTest.assertEquals((Object)rd1, (Object)rd1);
        SimpleFeature rdDuplicate = SimpleFeatureBuilder.copy((SimpleFeature)rd1);
        DataUtilitiesTest.assertEquals((Object)rd1, (Object)rdDuplicate);
        DataUtilitiesTest.assertNotSame((Object)rd1, (Object)rdDuplicate);
        SimpleFeature rd2 = DataUtilities.reType((SimpleFeatureType)this.roadType, (SimpleFeature)rd1);
        DataUtilitiesTest.assertEquals((Object)rd1, (Object)rd2);
        DataUtilitiesTest.assertNotSame((Object)rd1, (Object)rd2);
        SimpleFeature rd3 = DataUtilities.reType((SimpleFeatureType)this.subRoadType, (SimpleFeature)rd1);
        DataUtilitiesTest.assertFalse((boolean)rd1.equals(rd3));
        DataUtilitiesTest.assertEquals((int)2, (int)rd3.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)rd1.getID(), (String)rd3.getID());
        DataUtilitiesTest.assertEquals((Object)rd1.getAttribute("id"), (Object)rd3.getAttribute("id"));
        this.assertEquals((Geometry)rd1.getAttribute("geom"), (Geometry)rd3.getAttribute("geom"));
        DataUtilitiesTest.assertNotNull((Object)rd3.getDefaultGeometry());
        SimpleFeature rv1 = this.riverFeatures[0];
        DataUtilitiesTest.assertEquals((Object)rv1, (Object)rv1);
        SimpleFeature rvDuplicate = SimpleFeatureBuilder.copy((SimpleFeature)rv1);
        DataUtilitiesTest.assertEquals((Object)rv1, (Object)rvDuplicate);
        DataUtilitiesTest.assertNotSame((Object)rv1, (Object)rvDuplicate);
        SimpleFeature rv2 = DataUtilities.reType((SimpleFeatureType)this.riverType, (SimpleFeature)rv1);
        DataUtilitiesTest.assertEquals((Object)rv1, (Object)rv2);
        DataUtilitiesTest.assertNotSame((Object)rv1, (Object)rv2);
        SimpleFeature rv3 = DataUtilities.reType((SimpleFeatureType)this.subRiverType, (SimpleFeature)rv1);
        DataUtilitiesTest.assertFalse((boolean)rv1.equals(rv3));
        DataUtilitiesTest.assertEquals((int)2, (int)rv3.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)rv1.getID(), (String)rv3.getID());
        DataUtilitiesTest.assertEquals((Object)rv1.getAttribute("name"), (Object)rv3.getAttribute("name"));
        DataUtilitiesTest.assertEquals((Object)rv1.getAttribute("flow"), (Object)rv3.getAttribute("flow"));
        DataUtilitiesTest.assertNull((Object)rv3.getDefaultGeometry());
    }

    public void testCreate() throws Exception {
        SimpleFeatureType featureType = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:Geometry:srid=4326");
        SimpleFeature feature1 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"fid1=1|Jody Garnett\\nSteering Committee|POINT(1 2)");
        SimpleFeature feature2 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"2|John Hudson\\|Hapless Victim|POINT(6 2)");
        DataUtilitiesTest.assertNotNull((Object)featureType.getCoordinateReferenceSystem());
        Geometry geometry = (Geometry)feature1.getAttribute("geom");
        DataUtilitiesTest.assertEquals((String)"geom", (Object)2.0, (Object)geometry.getCoordinate().y);
        DataUtilitiesTest.assertEquals((String)"fid preservation", (String)"fid1", (String)feature1.getID());
        DataUtilitiesTest.assertEquals((String)"newline decode check", (Object)"Jody Garnett\nSteering Committee", (Object)feature1.getAttribute("party"));
        DataUtilitiesTest.assertEquals((String)"escape check", (Object)"John Hudson|Hapless Victim", (Object)feature2.getAttribute("party"));
        DataUtilitiesTest.assertEquals((String)"fid1", (String)feature1.getID());
        DataUtilitiesTest.assertNotNull((Object)feature2.getID());
        DataUtilitiesTest.assertEquals((String)feature2.getID(), (String)feature2.getIdentifier().getID());
        GeometryBuilder geomBuilder = new GeometryBuilder();
        DataUtilitiesTest.assertEquals((Object)geomBuilder.point(6.0, 2.0), (Object)feature2.getDefaultGeometry());
        DataUtilitiesTest.assertEquals((Object)geomBuilder.point(6.0, 2.0), (Object)feature2.getAttribute("geom"));
    }

    public void testEncode() throws Exception {
        SimpleFeatureType featureType = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:Geometry:srid=4326");
        SimpleFeature feature1 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"fid1=1|Jody Garnett\\nSteering Committee|POINT (1 2)");
        SimpleFeature feature2 = DataUtilities.createFeature((SimpleFeatureType)featureType, (String)"2|John Hudson\\|Hapless Victim|POINT (6 2)");
        String spec = DataUtilities.encodeType((SimpleFeatureType)featureType);
        DataUtilitiesTest.assertEquals((String)"id:Integer,party:String,geom:Geometry:srid=4326", (String)spec);
        String text = DataUtilities.encodeFeature((SimpleFeature)feature1);
        DataUtilitiesTest.assertEquals((String)"fid1=1|Jody Garnett\\nSteering Committee|POINT (1 2)", (String)text);
    }

    public void testDecodeGeometrySpec() throws Exception {
        SimpleFeatureType featureType1 = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:Geometry");
        SimpleFeatureType featureType2 = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:org.locationtech.jts.geom.Geometry");
        DataUtilitiesTest.assertEquals((Object)featureType1, (Object)featureType2);
        featureType2 = DataUtilities.createType((String)"Contact", (String)"id:Integer,party:String,geom:com.vividsolutions.jts.geom.Geometry");
        DataUtilitiesTest.assertEquals((Object)featureType1, (Object)featureType2);
        DataUtilitiesTest.assertEquals((Object)DataUtilities.createAttribute((String)"point:Point"), (Object)DataUtilities.createAttribute((String)"point:com.vividsolutions.jts.geom.Point"));
        DataUtilitiesTest.assertEquals((Object)DataUtilities.createAttribute((String)"point:Point"), (Object)DataUtilities.createAttribute((String)"point:org.locationtech.jts.geom.Point"));
        DataUtilitiesTest.assertEquals((Object)DataUtilities.createAttribute((String)"area:Polygon"), (Object)DataUtilities.createAttribute((String)"area:com.vividsolutions.jts.geom.Polygon"));
    }

    public void testTemplateFeatureType() throws IllegalAttributeException {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertNotNull((Object)feature);
        DataUtilitiesTest.assertEquals((int)this.roadType.getAttributeCount(), (int)feature.getAttributeCount());
    }

    public void testTemplateFeatureTypeString() throws IllegalAttributeException {
        SimpleFeature feature = DataUtilities.template((SimpleFeatureType)this.roadType, (String)"Foo");
        DataUtilitiesTest.assertNotNull((Object)feature);
        DataUtilitiesTest.assertEquals((int)this.roadType.getAttributeCount(), (int)feature.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"Foo", (String)feature.getID());
        DataUtilitiesTest.assertNull((Object)feature.getAttribute("name"));
        DataUtilitiesTest.assertNull((Object)feature.getAttribute("id"));
        DataUtilitiesTest.assertNull((Object)feature.getAttribute("geom"));
    }

    public void testDefaultValues() throws IllegalAttributeException {
        Object[] values = DataUtilities.defaultValues((SimpleFeatureType)this.roadType);
        DataUtilitiesTest.assertNotNull((Object)values);
        DataUtilitiesTest.assertEquals((int)values.length, (int)this.roadType.getAttributeCount());
    }

    public void testDefaultValue() throws IllegalAttributeException {
        DataUtilitiesTest.assertNull((Object)this.roadType.getDescriptor("name").getDefaultValue());
        DataUtilitiesTest.assertNull((Object)this.roadType.getDescriptor("id").getDefaultValue());
        DataUtilitiesTest.assertNull((Object)this.roadType.getDescriptor("geom").getDefaultValue());
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        Geometry geometry = fac.createGeometry((Geometry)point);
        DataUtilitiesTest.assertEquals((Object)geometry, (Object)DataUtilities.defaultValue(Geometry.class));
    }

    public void testDefaultValueArray() throws Exception {
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])DataUtilities.defaultValue(byte[].class)));
        Assert.assertArrayEquals((Object[])new String[0], (Object[])((String[])DataUtilities.defaultValue(String[].class)));
    }

    public void testCollection() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)collection.size());
    }

    public void testBounds() {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        ReferencedEnvelope expected = collection.getBounds();
        ReferencedEnvelope actual = DataUtilities.bounds((FeatureCollection)collection);
        DataUtilitiesTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testCollectionList() {
        SimpleFeatureCollection collection = DataUtilities.collection(Arrays.asList(this.roadFeatures));
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)collection.size());
    }

    public void testReaderFeatureArray() throws Exception {
        FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)this.count(reader));
    }

    public void testReaderCollection() throws Exception {
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)collection.size());
        SimpleFeatureReader reader = DataUtilities.reader((FeatureCollection)collection);
        DataUtilitiesTest.assertEquals((int)this.roadFeatures.length, (int)this.count((FeatureReader)reader));
    }

    public void testCreateSubType() throws Exception {
        SimpleFeatureType before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String");
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        DataUtilitiesTest.assertEquals((int)1, (int)after.getAttributeCount());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        URI here = new URI("http://localhost/");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (String)"now", (URI)here);
        DataUtilitiesTest.assertEquals((String)here.toString(), (String)after.getName().getNamespaceURI());
        DataUtilitiesTest.assertEquals((String)"now", (String)after.getName().getLocalPart());
        DataUtilitiesTest.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)after.getCoordinateReferenceSystem());
        DataUtilitiesTest.assertEquals((int)1, (int)after.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"the_geom", (String)after.getDescriptor(0).getLocalName());
        DataUtilitiesTest.assertNotNull((Object)after.getGeometryDescriptor());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        DataUtilitiesTest.assertEquals((Object)before.getGeometryDescriptor(), (Object)after.getGeometryDescriptor());
        before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String,population:Integer");
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom"});
        DataUtilitiesTest.assertEquals((Object)before.getGeometryDescriptor(), (Object)after.getGeometryDescriptor());
    }

    public void testCreateSubTypePreservesDefaultGeometryProperty() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("name", String.class);
        tb.add("the_geom1", Point.class, Integer.valueOf(4326));
        tb.add("the_geom2", Point.class, Integer.valueOf(4326));
        tb.add("the_geom3", Point.class, Integer.valueOf(4326));
        tb.setDefaultGeometry("the_geom2");
        SimpleFeatureType before = tb.buildFeatureType();
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom3"});
        DataUtilitiesTest.assertEquals((int)3, (int)after.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"the_geom1", (String)after.getGeometryDescriptor().getLocalName());
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom3"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DataUtilitiesTest.assertEquals((int)3, (int)after.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"the_geom1", (String)after.getGeometryDescriptor().getLocalName());
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom2"});
        DataUtilitiesTest.assertEquals((int)3, (int)after.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"the_geom2", (String)after.getGeometryDescriptor().getLocalName());
        after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"name", "the_geom1", "the_geom2"}, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DataUtilitiesTest.assertEquals((int)3, (int)after.getAttributeCount());
        DataUtilitiesTest.assertEquals((String)"the_geom2", (String)after.getGeometryDescriptor().getLocalName());
    }

    public void testCreateSubTypeWithPropertyNotMatchingAnAttributeDescriptor() throws Exception {
        SimpleFeatureType before = DataUtilities.createType((String)"cities", (String)"the_geom:Point:srid=4326,name:String");
        SimpleFeatureType after = DataUtilities.createSubType((SimpleFeatureType)before, (String[])new String[]{"the_geom", "name", "not_existing"});
        DataUtilitiesTest.assertEquals((int)2, (int)after.getAttributeCount());
        DataUtilitiesTest.assertNotNull((Object)after.getDescriptor("the_geom"));
        DataUtilitiesTest.assertNotNull((Object)after.getDescriptor("name"));
    }

    public void testSource() throws Exception {
        SimpleFeatureSource s = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        DataUtilitiesTest.assertEquals((int)3, (int)s.getCount(Query.ALL));
        DataUtilitiesTest.assertEquals((int)3, (int)s.getFeatures().size());
        DataUtilitiesTest.assertEquals((int)3, (int)s.getFeatures(Query.ALL).size());
        DataUtilitiesTest.assertEquals((int)3, (int)s.getFeatures((Filter)Filter.INCLUDE).size());
        DataUtilitiesTest.assertEquals((int)0, (int)s.getFeatures((Filter)Filter.EXCLUDE).size());
        DataUtilitiesTest.assertEquals((int)1, (int)s.getFeatures(this.rd1Filter).size());
        DataUtilitiesTest.assertEquals((int)2, (int)s.getFeatures(this.rd12Filter).size());
    }

    public void testMixQueries() throws Exception {
        Query firstQuery = new Query("typeName", (Filter)Filter.EXCLUDE, 100, new String[]{"att1", "att2", "att3"}, "handle");
        Query secondQuery = new Query("typeName", (Filter)Filter.EXCLUDE, 20, new String[]{"att1", "att2", "att4"}, "handle2");
        secondQuery.setStartIndex(Integer.valueOf(4));
        Query mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        DataUtilitiesTest.assertEquals((String)"newhandle", (String)mixed.getHandle());
        DataUtilitiesTest.assertEquals((int)20, (int)mixed.getMaxFeatures());
        DataUtilitiesTest.assertEquals((int)4, (int)mixed.getPropertyNames().length);
        DataUtilitiesTest.assertEquals((int)4, (int)mixed.getStartIndex());
        PropertyIsEqualTo filter1 = null;
        PropertyIsEqualTo filter2 = null;
        FilterFactory ffac = CommonFactoryFinder.getFilterFactory(null);
        String typeSpec = "geom:Point,att1:String,att2:String,att3:String,att4:String";
        SimpleFeatureType testType = DataUtilities.createType((String)"testType", (String)typeSpec);
        filter1 = ffac.equals((Expression)ffac.property("att1"), (Expression)ffac.literal((Object)"val1"));
        filter2 = ffac.equals((Expression)ffac.property("att2"), (Expression)ffac.literal((Object)"val2"));
        firstQuery = new Query("typeName", (Filter)filter1, 100, (String[])null, "handle");
        secondQuery = new Query("typeName", (Filter)filter2, 20, new String[]{"att1", "att2", "att4"}, "handle2");
        mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        DataUtilitiesTest.assertEquals((String)"newhandle", (String)mixed.getHandle());
        DataUtilitiesTest.assertEquals((int)20, (int)mixed.getMaxFeatures());
        DataUtilitiesTest.assertEquals((int)3, (int)mixed.getPropertyNames().length);
        Filter mixedFilter = mixed.getFilter();
        DataUtilitiesTest.assertNotNull((Object)mixedFilter);
        DataUtilitiesTest.assertTrue((boolean)(mixedFilter instanceof BinaryLogicOperator));
        BinaryLogicOperator f = (BinaryLogicOperator)mixedFilter;
        DataUtilitiesTest.assertTrue((boolean)(f instanceof And));
        for (Filter subFilter : f.getChildren()) {
            DataUtilitiesTest.assertTrue((filter1.equals(subFilter) || filter2.equals(subFilter) ? 1 : 0) != 0);
        }
        firstQuery.setHints(new Hints((RenderingHints.Key)Hints.USE_PROVIDED_FID, (Object)Boolean.TRUE));
        secondQuery.setHints(new Hints((RenderingHints.Key)Hints.FEATURE_2D, (Object)Boolean.TRUE));
        mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"newhandle");
        DataUtilitiesTest.assertEquals((int)2, (int)mixed.getHints().size());
        DataUtilitiesTest.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.USE_PROVIDED_FID)));
        DataUtilitiesTest.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.FEATURE_2D)));
    }

    public void testMixQueryAll() {
        Query firstQuery = new Query(Query.ALL);
        Query secondQuery = new Query(Query.ALL);
        firstQuery.setHints(new Hints((RenderingHints.Key)Hints.USE_PROVIDED_FID, (Object)Boolean.TRUE));
        secondQuery.setHints(new Hints((RenderingHints.Key)Hints.FEATURE_2D, (Object)Boolean.TRUE));
        Query mixed = DataUtilities.mixQueries((Query)firstQuery, (Query)secondQuery, (String)"mixer");
        DataUtilitiesTest.assertEquals((int)2, (int)mixed.getHints().size());
        DataUtilitiesTest.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.USE_PROVIDED_FID)));
        DataUtilitiesTest.assertTrue((boolean)((Boolean)mixed.getHints().get((Object)Hints.FEATURE_2D)));
    }

    public void testSimplifyFilter() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        And filter = ff.and((Filter)Filter.INCLUDE, (Filter)Filter.INCLUDE);
        Query query = new Query(Query.ALL);
        query.setFilter((Filter)filter);
        Query result = DataUtilities.simplifyFilter((Query)query);
        DataUtilitiesTest.assertEquals((Object)Filter.INCLUDE, (Object)result.getFilter());
    }

    public void testSpecNoCRS() throws Exception {
        String spec = "id:String,polygonProperty:Polygon";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)ft);
        DataUtilitiesTest.assertEquals((String)spec, (String)spec2);
    }

    public void testSpecCRS() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:srid=32615";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)ft);
        DataUtilitiesTest.assertEquals((String)spec, (String)spec2);
    }

    public void testAllGeometryTypes() throws Exception {
        List<Class> bindings = Arrays.asList(Geometry.class, Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class, GeometryCollection.class);
        StringBuilder specBuilder = new StringBuilder();
        bindings.forEach(b -> specBuilder.append(b.getSimpleName()).append("_type:").append(b.getName()).append(','));
        String spec = specBuilder.toString();
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        bindings.forEach(b -> {
            AttributeDescriptor descriptor = ft.getDescriptor(b.getSimpleName() + "_type");
            DataUtilitiesTest.assertNotNull((Object)descriptor);
            DataUtilitiesTest.assertEquals((Object)b, (Object)descriptor.getType().getBinding());
        });
    }

    public void testSpecNotIdentifiable() throws Exception {
        String spec = "id:String,polygonProperty:Polygon:srid=32615";
        SimpleFeatureType ft = DataUtilities.createType((String)"testType", (String)spec);
        CoordinateReferenceSystem crsNoId = CRS.parseWKT((String)"PROJCS[\"Geoscience Australia Standard National Scale Lambert Projection\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS_1978\",6378135,298.26],TOWGS84[0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Decimal_Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"central_meridian\",134.0],PARAMETER[\"latitude_of_origin\",0.0],PARAMETER[\"standard_parallel_1\",-18.0],PARAMETER[\"standard_parallel_2\",-36.0],UNIT[\"Meter\",1]]");
        SimpleFeatureType transformedFt = FeatureTypes.transform((SimpleFeatureType)ft, (CoordinateReferenceSystem)crsNoId);
        String expected = "id:String,polygonProperty:Polygon";
        String spec2 = DataUtilities.encodeType((SimpleFeatureType)transformedFt);
        DataUtilitiesTest.assertEquals((String)expected, (String)spec2);
    }

    public void testCreateView() throws Exception {
        String[] propNames = new String[]{"id", "geom"};
        Query query = new Query(this.roadType.getTypeName(), (Filter)Filter.INCLUDE, 100, propNames, null);
        SimpleFeatureSource source = DataUtilities.source((SimpleFeature[])this.roadFeatures);
        SimpleFeatureSource view = DataUtilities.createView((SimpleFeatureSource)source, (Query)query);
        DataUtilitiesTest.assertNotNull((Object)view);
        List desc = ((SimpleFeatureType)view.getSchema()).getAttributeDescriptors();
        DataUtilitiesTest.assertTrue((desc.size() == propNames.length ? 1 : 0) != 0);
        DataUtilitiesTest.assertTrue((boolean)((AttributeDescriptor)desc.get(0)).getLocalName().equals(propNames[0]));
        DataUtilitiesTest.assertTrue((boolean)((AttributeDescriptor)desc.get(1)).getLocalName().equals(propNames[1]));
    }

    public void testAddMandatoryProperties() {
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl("String"), String.class, false, false, Collections.EMPTY_LIST, null, null);
        AttributeDescriptorImpl descr1 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att1"), 0, 1, false, null);
        AttributeDescriptorImpl descr2 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att2"), 0, 1, false, null);
        AttributeDescriptorImpl descr3 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att3"), 1, 1, false, null);
        AttributeDescriptorImpl descr4 = new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("att4"), 1, 1, false, null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("type");
        tb.add((AttributeDescriptor)descr1);
        tb.add((AttributeDescriptor)descr2);
        tb.add((AttributeDescriptor)descr3);
        tb.add((AttributeDescriptor)descr4);
        SimpleFeatureType type = tb.buildFeatureType();
        PropertyName propName1 = this.ff.property("att1");
        PropertyName propName2 = this.ff.property("att2");
        PropertyName propName3 = this.ff.property("att3");
        PropertyName propName4 = this.ff.property("att4");
        ArrayList<PropertyName> list = new ArrayList<PropertyName>();
        list.add(propName1);
        list.add(propName4);
        List list2 = DataUtilities.addMandatoryProperties((SimpleFeatureType)type, list);
        DataUtilitiesTest.assertTrue((boolean)list2.contains(propName1));
        DataUtilitiesTest.assertTrue((!list2.contains(propName2) ? 1 : 0) != 0);
        DataUtilitiesTest.assertTrue((boolean)list2.contains(propName3));
        DataUtilitiesTest.assertTrue((boolean)list2.contains(propName4));
        DataUtilitiesTest.assertEquals((int)3, (int)list2.size());
    }

    public void testMixQueriesSort() {
        Query q1 = new Query();
        Query q2 = new Query();
        q2.setSortBy(new SortBy[]{SortBy.NATURAL_ORDER});
        Assert.assertThat((Object)DataUtilities.mixQueries((Query)q1, (Query)q2, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.NATURAL_ORDER}));
        Assert.assertThat((Object)DataUtilities.mixQueries((Query)q2, (Query)q1, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.NATURAL_ORDER}));
        Query q3 = new Query();
        q3.setSortBy(new SortBy[]{SortBy.REVERSE_ORDER});
        Assert.assertThat((Object)DataUtilities.mixQueries((Query)q2, (Query)q3, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.REVERSE_ORDER}));
        Assert.assertThat((Object)DataUtilities.mixQueries((Query)q3, (Query)q2, null).getSortBy(), (Matcher)Matchers.arrayContaining((Object[])new SortBy[]{SortBy.NATURAL_ORDER}));
    }
}

