/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.awt.geom.Point2D;
import java.util.regex.Pattern;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.WrappingCoordinateFilter;
import org.geotools.util.SoftValueHashMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class GeosValidAreaCache {
    private static final int AZIMUTH_SAMPLES = 360;
    private static final int BISECTION_ITERS = 25;
    private static final double INWARD_FACTOR = 0.9999;
    private static final GeometryFactory GF = new GeometryFactory();
    private static final Geometry WORLD = GF.toGeometry(new Envelope(-180.0, 180.0, -90.0, 90.0));
    private static final Geometry WORLD_LEFT = GF.toGeometry(new Envelope(-360.0, -180.0, -90.0, 90.0));
    private static final Geometry WORLD_RIGHT = GF.toGeometry(new Envelope(180.0, 360.0, -90.0, 90.0));
    private final SoftValueHashMap<CrsKey, Geometry> validAreaCache = new SoftValueHashMap();

    GeosValidAreaCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Geometry getValidAreaInGeosCrs(CoordinateReferenceSystem geosCrs) throws FactoryException, TransformException {
        CrsKey key = CrsKey.of(geosCrs);
        Geometry cached = (Geometry)this.validAreaCache.get((Object)key);
        if (cached != null) {
            return cached;
        }
        SoftValueHashMap<CrsKey, Geometry> softValueHashMap = this.validAreaCache;
        synchronized (softValueHashMap) {
            cached = (Geometry)this.validAreaCache.get((Object)key);
            if (cached != null) {
                return cached;
            }
            Geometry wgs84 = GeosValidAreaCache.buildValidAreaWgs84(geosCrs);
            this.validAreaCache.put((Object)key, (Object)wgs84);
            return wgs84;
        }
    }

    private static Geometry buildValidAreaWgs84(CoordinateReferenceSystem geostationary) throws FactoryException {
        if (!(geostationary instanceof ProjectedCRS)) {
            throw new IllegalArgumentException("Expected a ProjectedCRS, got: " + String.valueOf(geostationary.getClass()));
        }
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)geostationary);
        ParameterValueGroup params = mapProjection.getParameterValues();
        double centralMeridian = params.parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
        double satelliteHeight = params.parameter(GeostationarySatellite.Provider.SATELLITE_HEIGHT.getName().getCode()).doubleValue();
        Ellipsoid ellipsoid = CRS.getEllipsoid((CoordinateReferenceSystem)geostationary);
        double angle = GeosValidAreaCache.computeAngularRadiusDeg(ellipsoid, satelliteHeight);
        return GeosValidAreaCache.buildValidAreaWgs84(geostationary, centralMeridian, angle, ellipsoid, 360, 25);
    }

    private static double computeAngularRadiusDeg(Ellipsoid ellipsoid, double satelliteHeightMeters) {
        double r = ellipsoid.getSemiMajorAxis();
        double h = satelliteHeightMeters;
        double cos = r / (r + h);
        cos = Math.max(-1.0, Math.min(1.0, cos));
        double angleRad = Math.acos(cos);
        return Math.toDegrees(angleRad);
    }

    private static Geometry buildValidAreaWgs84(CoordinateReferenceSystem geostationary, double centralMeridian, double angle, Ellipsoid ellipsoid, int azimuthSamples, int bisectionIters) throws FactoryException {
        MathTransform fwd = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)geostationary, (boolean)true);
        GeodeticCalculator gc = new GeodeticCalculator(ellipsoid);
        double dMaxMeters = Math.toRadians(angle) * ellipsoid.getSemiMajorAxis();
        Coordinate[] coords = new Coordinate[azimuthSamples + 1];
        double step = 360.0 / (double)azimuthSamples;
        for (int i = 0; i < azimuthSamples; ++i) {
            double az = (double)i * step;
            double lo = 0.0;
            double hi = dMaxMeters;
            for (int k = 0; k < bisectionIters; ++k) {
                double d = (lo + hi) * 0.5;
                Point2D ll = GeosValidAreaCache.destination(gc, centralMeridian, az, d);
                if (GeosValidAreaCache.isForwardTransformOk(fwd, ll.getX(), ll.getY())) {
                    lo = d;
                    continue;
                }
                hi = d;
            }
            double dSafe = lo * 0.9999;
            Point2D p = GeosValidAreaCache.destination(gc, centralMeridian, az, dSafe);
            double lon = p.getX();
            double lat = p.getY();
            coords[i] = new Coordinate(lon, lat);
        }
        coords[azimuthSamples] = new Coordinate(coords[0]);
        Polygon polygon = GF.createPolygon(GF.createLinearRing(coords));
        return GeosValidAreaCache.normalizeDateline((Geometry)polygon);
    }

    private static Point2D destination(GeodeticCalculator gc, double lon0, double azDeg, double distMeters) {
        gc.setStartingGeographicPoint(lon0, 0.0);
        gc.setDirection(azDeg, distMeters);
        return gc.getDestinationGeographicPoint();
    }

    private static boolean isForwardTransformOk(MathTransform fwd, double lon, double lat) {
        try {
            double[] src = new double[]{lon, lat};
            double[] dst = new double[2];
            fwd.transform(src, 0, dst, 0, 1);
            return Double.isFinite(dst[0]) && Double.isFinite(dst[1]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Geometry normalizeDateline(Geometry poly) {
        Envelope env = poly.getEnvelopeInternal();
        if (env.getWidth() < 180.0) {
            return poly;
        }
        WrappingCoordinateFilter filter = new WrappingCoordinateFilter(180.0, 360.0, null, false, true);
        poly.apply((GeometryComponentFilter)filter);
        poly.geometryChanged();
        env = poly.getEnvelopeInternal();
        if (env.getMinX() < -180.0) {
            Geometry left = poly.intersection(WORLD_LEFT);
            Geometry leftTranslated = AffineTransformation.translationInstance((double)360.0, (double)0.0).transform(left);
            Geometry right = poly.intersection(WORLD);
            return right.union(leftTranslated);
        }
        if (env.getMaxX() > 180.0) {
            Geometry left = poly.intersection(WORLD);
            Geometry right = poly.intersection(WORLD_RIGHT);
            Geometry rightTranslated = AffineTransformation.translationInstance((double)-360.0, (double)0.0).transform(right);
            return rightTranslated.union(left);
        }
        return poly;
    }

    private static final class CrsKey {
        private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
        private final String signature;
        private final int hash;

        private CrsKey(String signature) {
            this.signature = signature;
            this.hash = signature.hashCode();
        }

        static CrsKey of(CoordinateReferenceSystem crs) {
            String wkt = crs.toWKT().replaceAll("\\s+", " ").trim();
            String canonical = WHITESPACE_PATTERN.matcher(wkt).replaceAll(" ").trim();
            return new CrsKey(canonical);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CrsKey && this.signature.equals(((CrsKey)o).signature);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

