/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.GeostationarySatellite;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.GeosValidAreaCache;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class GeosProjectionHandlerFactory
implements ProjectionHandlerFactory {
    public static final Polygon WORLD = JTS.toGeometry(new Envelope(-180.0, 180.0, -90.0, 90.0));
    private static final GeosValidAreaCache VALID_AREA_CACHE = new GeosValidAreaCache();

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCRS, boolean wrap, int wrapLimit) throws FactoryException {
        CoordinateReferenceSystem targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)targetCRS);
        if (!(mapProjection instanceof GeostationarySatellite)) {
            return null;
        }
        try {
            Geometry validArea = VALID_AREA_CACHE.getValidAreaInGeosCrs(targetCRS);
            return new GeosProjectionHandler(sourceCRS, validArea, renderingEnvelope);
        }
        catch (TransformException e) {
            throw new FactoryException("Failed to calculate valid area for GeostationarySatellite projection", (Throwable)e);
        }
    }

    class GeosProjectionHandler
    extends ProjectionHandler {
        Geometry p1;
        Geometry p2;

        public GeosProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope) throws FactoryException {
            super(sourceCRS, validArea, renderingEnvelope);
            if (validArea instanceof MultiPolygon) {
                MultiPolygon mp = (MultiPolygon)validArea;
                this.p1 = mp.getGeometryN(0);
                this.p2 = mp.getGeometryN(1);
            }
        }

        @Override
        protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
            return this.transformEnvelope(envelope, targetCRS, this.validArea);
        }

        protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS, Geometry validArea) throws FactoryException, TransformException {
            Polygon geometry;
            Geometry intersection;
            CoordinateReferenceSystem envelopeCRS = envelope.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata((Object)envelopeCRS, (Object)targetCRS)) {
                return envelope;
            }
            Geometry validAreaInEnvelopeCRS = JTS.transform(validArea, CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)envelopeCRS));
            if (validArea instanceof MultiPolygon) {
                validAreaInEnvelopeCRS = validAreaInEnvelopeCRS.buffer(0.0);
            }
            if ((intersection = (geometry = JTS.toGeometry(envelope)).intersection(validAreaInEnvelopeCRS)) == null || intersection.isEmpty()) {
                return null;
            }
            Envelope ie = intersection.getEnvelopeInternal();
            double distance = (ie.getWidth() / 10.0 + ie.getHeight() / 10.0) / 2.0;
            intersection = Densifier.densify((Geometry)intersection, (double)distance);
            Geometry transformed = JTS.transform(intersection, CRS.findMathTransform((CoordinateReferenceSystem)envelopeCRS, (CoordinateReferenceSystem)targetCRS));
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(targetCRS), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true, Collections.emptyMap());
            if (handler == null || handler instanceof WrappingProjectionHandler) {
                return new ReferencedEnvelope(transformed.getEnvelopeInternal(), targetCRS);
            }
            ReferencedEnvelope validAreaBounds = handler.getValidAreaBounds();
            Polygon validAreaTarget = JTS.toGeometry(validAreaBounds.transform(targetCRS, true));
            Geometry reduced = transformed.intersection((Geometry)validAreaTarget);
            if (reduced == null || reduced.isEmpty()) {
                return null;
            }
            return new ReferencedEnvelope(reduced.getEnvelopeInternal(), targetCRS);
        }

        @Override
        public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
            if (this.p1 == null) {
                return super.getQueryEnvelopes();
            }
            ReferencedEnvelope e1 = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS, this.p1);
            ReferencedEnvelope e2 = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS, this.p2);
            if (e1 != null && e2 != null && e1.intersects(e2)) {
                e1.expandToInclude(e2);
                return Collections.singletonList(e1);
            }
            ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
            if (e1 != null) {
                result.add(e1);
            }
            if (e2 != null) {
                result.add(e2);
            }
            return result;
        }
    }
}

