/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class CompoundCurve
extends LineString
implements CompoundCurvedGeometry<LineString> {
    private static final long serialVersionUID = -5796254063449438787L;
    List<LineString> components;
    LineString linearized;
    double tolerance;

    public CompoundCurve(List<LineString> components, GeometryFactory factory, double tolerance) {
        super(CircularString.FAKE_STRING_2D, factory);
        this.tolerance = tolerance;
        this.components = new ArrayList<LineString>();
        for (LineString ls : components) {
            if (ls instanceof CompoundCurve) {
                CompoundCurve cc = (CompoundCurve)ls;
                this.components.addAll(cc.components);
                continue;
            }
            this.components.add(ls);
        }
        if (components.size() > 1) {
            LineString prev = components.get(0);
            for (int i = 1; i < components.size(); ++i) {
                Coordinate startPoint;
                LineString curr = components.get(i);
                Coordinate endPoint = prev.getCoordinateN(prev.getNumPoints() - 1);
                if (!endPoint.equals((Object)(startPoint = curr.getCoordinateN(0)))) {
                    throw new IllegalArgumentException("Found two elements that are not connected, " + String.valueOf(prev) + " and " + String.valueOf(curr));
                }
                prev = curr;
            }
        }
    }

    @Override
    public int getCoordinatesDimension() {
        if (this.components.isEmpty()) {
            return 2;
        }
        int dimension = Integer.MAX_VALUE;
        for (LineString component : this.components) {
            int curr = component instanceof CurvedGeometry ? ((CurvedGeometry)component).getCoordinatesDimension() : component.getCoordinateSequence().getDimension();
            dimension = Math.min(curr, dimension);
        }
        return dimension;
    }

    @Override
    public LineString linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public LineString linearize(double tolerance) {
        boolean isDefaultTolerance = CircularArc.equals(tolerance, this.tolerance);
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized;
        }
        CoordinateSequence cs = this.getLinearizedCoordinateSequence(tolerance);
        LineString result = new LineString(cs, this.factory);
        if (isDefaultTolerance) {
            this.linearized = result;
        }
        return result;
    }

    protected CoordinateSequence getLinearizedCoordinateSequence(double tolerance) {
        GrowableOrdinateArray gar = new GrowableOrdinateArray();
        for (LineString component : this.components) {
            if (gar.size() > 0) {
                gar.setSize(gar.size() - 2);
            }
            if (component instanceof SingleCurvedGeometry) {
                SingleCurvedGeometry curved = (SingleCurvedGeometry)component;
                CoordinateSequence cs = curved.getLinearizedCoordinateSequence(tolerance);
                gar.addAll(cs);
                continue;
            }
            CoordinateSequence cs = component.getCoordinateSequence();
            for (int i = 0; i < cs.size(); ++i) {
                gar.add(cs.getX(i), cs.getY(i));
            }
        }
        CoordinateSequence cs = gar.toCoordinateSequence(this.getFactory());
        return cs;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public List<LineString> getComponents() {
        return this.components;
    }

    public boolean isClosed() {
        LineString firstComponent = this.components.get(0);
        LineString lastComponent = this.components.get(this.components.size() - 1);
        return firstComponent.getStartPoint().equals((Geometry)lastComponent.getEndPoint());
    }

    public int getDimension() {
        return super.getDimension();
    }

    public int getBoundaryDimension() {
        return super.getDimension();
    }

    public boolean isEmpty() {
        for (LineString ls : this.components) {
            if (ls.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String getGeometryType() {
        return "CompoundCurve";
    }

    public CompoundCurve reverse() {
        return (CompoundCurve)super.reverse();
    }

    public CompoundCurve reverseInternal() {
        ArrayList<LineString> reversedComponents = new ArrayList<LineString>(this.components.size());
        for (LineString ls : this.components) {
            LineString reversed = ls.reverse();
            reversedComponents.add(0, reversed);
        }
        return new CompoundCurve(reversedComponents, this.getFactory(), this.tolerance);
    }

    public Point getInteriorPoint() {
        return this.components.get(this.components.size() / 2).getInteriorPoint();
    }

    public Geometry getEnvelope() {
        return super.getEnvelope();
    }

    public Envelope getEnvelopeInternal() {
        return super.getEnvelopeInternal();
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope result = new Envelope();
        for (LineString ls : this.components) {
            result.expandToInclude(ls.getEnvelopeInternal());
        }
        return result;
    }

    public int getNumGeometries() {
        return this.components.size();
    }

    public Geometry getGeometryN(int n) {
        return (Geometry)this.components.get(n);
    }

    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    public int getSRID() {
        return super.getSRID();
    }

    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    public Object getUserData() {
        return super.getUserData();
    }

    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CompoundCurve) {
            CompoundCurve ccOther = (CompoundCurve)other;
            if (ccOther.components.size() != this.components.size()) {
                return false;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                LineString ls2;
                LineString ls1 = this.components.get(i);
                if (ls1.equalsExact((Geometry)(ls2 = ccOther.components.get(i)), tolerance)) continue;
                return false;
            }
            return true;
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    public boolean equals(Geometry other) {
        if (other instanceof CompoundCurve) {
            CompoundCurve ccOther = (CompoundCurve)other;
            if (ccOther.components.size() != this.components.size()) {
                return false;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                LineString ls2;
                LineString ls1 = this.components.get(i);
                if (ls1.equals((Geometry)(ls2 = ccOther.components.get(i)))) continue;
                return false;
            }
            return true;
        }
        return this.linearize().equals(other);
    }

    public boolean equalsTopo(Geometry other) {
        if (other instanceof CompoundCurve) {
            CompoundCurve ccOther = (CompoundCurve)other;
            if (ccOther.components.size() != this.components.size()) {
                return false;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                LineString ls2;
                LineString ls1 = this.components.get(i);
                if (ls1.equalsTopo((Geometry)(ls2 = ccOther.components.get(i)))) continue;
                return false;
            }
            return true;
        }
        return this.linearize().equalsTopo(other);
    }

    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            return this.equals((Geometry)o);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("COMPOUNDCURVE ");
        if (this.components.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            for (int k = 0; k < this.components.size(); ++k) {
                LineString component = this.components.get(k);
                if (component instanceof SingleCurvedGeometry) {
                    SingleCurvedGeometry curved = (SingleCurvedGeometry)component;
                    sb.append(curved.toCurvedText());
                } else {
                    sb.append("(");
                    CoordinateSequence cs = component.getCoordinateSequence();
                    for (int i = 0; i < cs.size(); ++i) {
                        sb.append(cs.getX(i) + " " + cs.getY(i));
                        if (i >= cs.size() - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(")");
                }
                if (k >= this.components.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    public boolean isRectangle() {
        return this.linearize().isRectangle();
    }

    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.linearize().getCoordinateSequence();
    }

    public Coordinate getCoordinateN(int n) {
        return this.linearize().getCoordinateN(n);
    }

    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    public int getNumPoints() {
        return this.linearize().getNumPoints();
    }

    public Point getPointN(int n) {
        return this.linearize().getPointN(n);
    }

    public Point getStartPoint() {
        return this.linearize().getStartPoint();
    }

    public Point getEndPoint() {
        return this.linearize().getEndPoint();
    }

    public boolean isRing() {
        return this.linearize().isRing();
    }

    public double getLength() {
        return this.linearize().getLength();
    }

    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    public CompoundCurve copyInternal() {
        return new CompoundCurve(this.components, this.factory, this.tolerance);
    }

    public void normalize() {
        this.linearize().normalize();
    }

    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    public boolean isValid() {
        return this.linearize().isValid();
    }

    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    public double getArea() {
        return this.linearize().getArea();
    }

    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    public Geometry union() {
        return this.linearize().union();
    }

    public Geometry norm() {
        return this.linearize().norm();
    }

    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    public String toText() {
        return this.linearize().toText();
    }
}

