/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.opengis.filter.capability.FunctionName;

public class PointOnLineFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("pointOnLine", Point.class, FunctionNameImpl.parameter("linestring", Geometry.class), FunctionNameImpl.parameter("percentage", Double.class, 0, 1));

    public PointOnLineFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object object) {
        Double d;
        Geometry geometry = (Geometry)this.getExpression(0).evaluate(object, Geometry.class);
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            if (collection.getNumGeometries() == 0) {
                return null;
            }
            if (collection.getNumGeometries() > 1) {
                throw new IllegalArgumentException("Expected a single geometry, got a collection of " + collection.getNumGeometries() + " geometries");
            }
            geometry = collection.getGeometryN(0);
        }
        if (!(geometry instanceof LineString)) {
            throw new IllegalArgumentException("Expected a LineString, got a " + geometry.getGeometryType());
        }
        LineString line = (LineString)geometry;
        Double percentage = 0.5;
        if (this.getParameters().size() > 1 && (d = (Double)this.getExpression(1).evaluate(object, Double.class)) != null) {
            percentage = d;
        }
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Expected a percentage between 0 and 1, got " + percentage);
        }
        LengthIndexedLine index = new LengthIndexedLine((Geometry)line);
        double position = index.getEndIndex() * percentage;
        Coordinate c = index.extractPoint(position);
        return geometry.getFactory().createPoint(c);
    }
}

