/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.MathExpressionImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.Attributes;

public class ExpressionSAXParser {
    private static final Logger LOGGER = Logging.getLogger(ExpressionSAXParser.class);
    private FilterFactory2 ff;
    private FunctionFinder functionFinder = new FunctionFinder(null);
    private ExpressionSAXParser expFactory = null;
    private Expression curExprssn = null;
    private String currentState = null;
    private List<Expression> expressions = new ArrayList<Expression>();
    private String declaredType = null;
    private boolean readyFlag = false;
    private SimpleFeatureType schema;
    private boolean readChars = false;

    public ExpressionSAXParser() {
        this(CommonFactoryFinder.getFilterFactory2());
    }

    public ExpressionSAXParser(FilterFactory2 factory) {
        this(null, factory);
    }

    public ExpressionSAXParser(SimpleFeatureType schema) {
        this(schema, CommonFactoryFinder.getFilterFactory2());
    }

    public ExpressionSAXParser(SimpleFeatureType schema, FilterFactory2 factory) {
        this.schema = schema;
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory2 factory) {
        this.ff = factory;
    }

    public void start(String declaredType, Attributes atts) throws IllegalFilterException {
        LOGGER.finer("incoming type: " + declaredType);
        LOGGER.finer("declared type: " + this.declaredType);
        LOGGER.finer("current state: " + this.currentState);
        if (this.expFactory == null) {
            this.declaredType = declaredType;
            short convertType = ExpressionSAXParser.convertType(declaredType);
            if (DefaultExpression.isFunctionExpression(convertType)) {
                this.expFactory = new ExpressionSAXParser(this.schema);
                String name = this.getFunctionName(atts);
                Function function = this.functionFinder.findFunction(name);
                if (function == null || !(function instanceof FunctionExpression)) {
                    throw new IllegalFilterException(name + " not availabel as FunctionExpressio:" + String.valueOf(function));
                }
                this.curExprssn = function;
                LOGGER.finer("is <function> expression");
            }
            if (DefaultExpression.isMathExpression(convertType)) {
                this.expFactory = new ExpressionSAXParser(this.schema);
                switch (convertType) {
                    case 105: {
                        this.curExprssn = new AddImpl(null, null);
                        break;
                    }
                    case 106: {
                        this.curExprssn = new SubtractImpl(null, null);
                        break;
                    }
                    case 107: {
                        this.curExprssn = new MultiplyImpl(null, null);
                        break;
                    }
                    case 108: {
                        this.curExprssn = new DivideImpl(null, null);
                        break;
                    }
                    default: {
                        throw new IllegalFilterException("Unsupported math expression");
                    }
                }
                LOGGER.finer("is math expression");
            } else if (DefaultExpression.isLiteralExpression(convertType)) {
                this.curExprssn = new LiteralExpressionImpl();
                this.readChars = true;
                LOGGER.finer("is literal expression");
            } else if (DefaultExpression.isAttributeExpression(convertType)) {
                this.curExprssn = new AttributeExpressionImpl(this.schema);
                this.readChars = true;
                LOGGER.finer("is attribute expression");
            }
            this.currentState = ExpressionSAXParser.setInitialState(this.curExprssn);
            this.readyFlag = false;
        } else {
            this.expFactory.start(declaredType, atts);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void end(String message) throws IllegalFilterException {
        LOGGER.finer("declared type: " + this.declaredType);
        LOGGER.finer("end message: " + message);
        LOGGER.finer("current state: " + this.currentState);
        LOGGER.finest("expression factory: " + String.valueOf(this.expFactory));
        if (this.expFactory != null) {
            this.expFactory.end(message);
            if (!this.expFactory.isReady()) return;
            if (this.currentState.equals("leftValue")) {
                ((MathExpressionImpl)this.curExprssn).setExpression1(this.expFactory.create());
                this.currentState = "rightValue";
                this.expFactory = new ExpressionSAXParser(this.schema);
                LOGGER.finer("just added left value: " + this.currentState);
                return;
            } else if (this.currentState.equals("rightValue")) {
                ((MathExpressionImpl)this.curExprssn).setExpression2(this.expFactory.create());
                this.currentState = "complete";
                this.expFactory = null;
                LOGGER.finer("just added right value: " + this.currentState);
                return;
            } else {
                if (!this.currentState.equals("accumulate")) throw new IllegalFilterException("Attempted to add sub expression in a bad state: " + this.currentState);
                this.expressions.add(this.expFactory.create());
                this.expFactory = null;
                LOGGER.finer("just added a parameter for a function: " + this.currentState);
                if (((FunctionExpression)this.curExprssn).getFunctionName().getArgumentCount() == this.expressions.size()) {
                    this.currentState = "complete";
                    ((FunctionExpression)this.curExprssn).setParameters(this.expressions);
                    return;
                } else {
                    this.expFactory = new ExpressionSAXParser(this.schema);
                }
            }
            return;
        } else {
            if (!this.declaredType.equals(message) || !this.currentState.equals("complete")) throw new IllegalFilterException("Reached end of unready, non-nested expression: " + this.currentState);
            this.readChars = false;
            this.readyFlag = true;
        }
    }

    public boolean isReady() {
        return this.readyFlag;
    }

    public void message(String message, boolean convertToNumber) throws IllegalFilterException {
        LOGGER.finer("incoming message: " + message);
        LOGGER.finer("should read chars: " + this.readChars);
        if (this.readChars) {
            if (this.curExprssn instanceof PropertyName) {
                LOGGER.finer("...");
                String[] splitName = message.split("[.:/]");
                String newAttName = message;
                newAttName = splitName.length == 1 ? splitName[0] : splitName[splitName.length - 1];
                LOGGER.finer("setting attribute expression: " + newAttName);
                ((AttributeExpressionImpl)this.curExprssn).setPropertyName(newAttName);
                LOGGER.finer("...");
                this.currentState = "complete";
                LOGGER.finer("...");
            } else if (this.curExprssn instanceof Literal) {
                if (convertToNumber) {
                    try {
                        Integer temp = Integer.valueOf(message);
                        ((LiteralExpressionImpl)this.curExprssn).setValue(temp);
                        this.currentState = "complete";
                    }
                    catch (NumberFormatException nfe1) {
                        try {
                            Double temp = Double.valueOf(message);
                            ((LiteralExpressionImpl)this.curExprssn).setValue(temp);
                            this.currentState = "complete";
                        }
                        catch (NumberFormatException nfe2) {
                            String temp = message;
                            ((LiteralExpressionImpl)this.curExprssn).setValue(temp);
                            this.currentState = "complete";
                        }
                    }
                } else {
                    String temp = message;
                    ((LiteralExpressionImpl)this.curExprssn).setValue(temp);
                    this.currentState = "complete";
                }
            } else if (this.expFactory != null) {
                this.expFactory.message(message, convertToNumber);
            }
        } else if (this.expFactory != null) {
            this.expFactory.message(message, convertToNumber);
        }
    }

    public void geometry(Geometry geometry) throws IllegalFilterException {
        LOGGER.finer("got geometry: " + geometry.toString());
        this.curExprssn = new LiteralExpressionImpl();
        ((LiteralExpressionImpl)this.curExprssn).setValue(geometry);
        LOGGER.finer("set expression: " + this.curExprssn.toString());
        this.currentState = "complete";
        LOGGER.finer("set current state: " + this.currentState);
    }

    public Expression create() {
        LOGGER.finer("about to create expression: " + this.curExprssn.toString());
        return this.curExprssn;
    }

    private static String setInitialState(Expression expression) throws IllegalFilterException {
        if (expression instanceof BinaryExpression) {
            return "leftValue";
        }
        if (expression instanceof PropertyName || expression instanceof Literal) {
            return "";
        }
        if (expression instanceof FunctionExpression) {
            return "accumulate";
        }
        throw new IllegalFilterException("Created illegal expression: " + expression.getClass().toString());
    }

    protected static short convertType(String expType) {
        if (expType.equals("Add")) {
            return 105;
        }
        if (expType.equals("Sub")) {
            return 106;
        }
        if (expType.equals("Mul")) {
            return 107;
        }
        if (expType.equals("Div")) {
            return 108;
        }
        if (expType.equals("PropertyName")) {
            return 109;
        }
        if (expType.equals("Literal")) {
            return 101;
        }
        if (expType.equals("Function")) {
            return 114;
        }
        return 115;
    }

    public String getFunctionName(Attributes map) {
        String result = map.getValue("name");
        if (result == null) {
            result = map.getValue("ogc:name");
        }
        if (result == null) {
            result = map.getValue("ows:name");
        }
        return result;
    }
}

