/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.NamespaceSupport;

public final class ExpressionDOMParser {
    private static final Logger LOGGER = Logging.getLogger(ExpressionDOMParser.class);
    private FilterFactory2 ff;
    private static GeometryFactory gfac = new GeometryFactory();
    private static final int NUM_BOX_COORDS = 5;

    public ExpressionDOMParser(FilterFactory2 filterFactory) {
        Objects.requireNonNull(filterFactory);
        this.ff = filterFactory;
    }

    public ExpressionDOMParser() {
        this(CommonFactoryFinder.getFilterFactory2(null));
    }

    public void setFilterFactory(FilterFactory2 filterFactory) {
        Objects.requireNonNull(filterFactory);
        this.ff = filterFactory;
    }

    private static NamespaceSupport getNameSpaces(Node node) {
        NamespaceSupport namespaces = new NamespaceSupport();
        while (node != null) {
            NamedNodeMap atts = node.getAttributes();
            if (atts != null) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    Node att = atts.item(i);
                    if (att.getNamespaceURI() == null || !att.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || namespaces.getURI(att.getLocalName()) != null) continue;
                    namespaces.declarePrefix(att.getLocalName(), att.getNodeValue());
                }
            }
            node = node.getParentNode();
        }
        return namespaces;
    }

    public Expression expression(Node root) {
        String childName;
        if (root == null || root.getNodeType() != 1) {
            LOGGER.finer("bad node input ");
            return null;
        }
        LOGGER.finer("processing root " + root.getLocalName());
        Node child = root;
        String string = childName = child.getLocalName() != null ? child.getLocalName() : child.getNodeName();
        if (childName.indexOf(58) != -1) {
            childName = childName.substring(childName.indexOf(58) + 1);
        }
        if (childName.equalsIgnoreCase("Literal")) {
            LOGGER.finer("processing literal " + String.valueOf(child));
            NodeList kidList = child.getChildNodes();
            LOGGER.finest("literal elements (" + kidList.getLength() + ") " + kidList.toString());
            for (int i = 0; i < kidList.getLength(); ++i) {
                Node kid = kidList.item(i);
                LOGGER.finest("kid " + i + " " + String.valueOf(kid));
                if (kid == null) {
                    LOGGER.finest("Skipping ");
                    continue;
                }
                if (kid.getNodeValue() == null) {
                    LOGGER.finer("node " + kid.getNodeValue() + " namespace " + kid.getNamespaceURI());
                    LOGGER.fine("a literal gml string?");
                    try {
                        Geometry geom = this.gml(kid);
                        if (geom != null) {
                            LOGGER.finer("built a " + geom.getGeometryType() + " from gml");
                            LOGGER.finer("\tpoints: " + geom.getNumPoints());
                        } else {
                            LOGGER.finer("got a null geometry back from gml parser");
                        }
                        return this.ff.literal((Object)geom);
                    }
                    catch (IllegalFilterException ife) {
                        LOGGER.warning("Problem building GML/JTS object: " + String.valueOf(ife));
                        return null;
                    }
                }
                if (kid.getNodeType() != 4 && kid.getNodeValue().trim().length() == 0) {
                    LOGGER.finest("empty text element");
                    continue;
                }
                String nodeValue = kid.getNodeValue();
                LOGGER.finer("processing " + nodeValue);
                try {
                    return this.ff.literal((Object)nodeValue);
                }
                catch (IllegalFilterException ife) {
                    LOGGER.finer("Unable to build expression " + String.valueOf(ife));
                    return null;
                }
            }
            return this.ff.literal((Object)"");
        }
        if (childName.equalsIgnoreCase("add")) {
            try {
                LOGGER.fine("processing an Add");
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + String.valueOf(value) + "<-");
                Expression left = this.expression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + String.valueOf(value) + "<-");
                Expression right = this.expression(value);
                return this.ff.add(left, right);
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + String.valueOf(ife));
                return null;
            }
        }
        if (childName.equalsIgnoreCase("sub")) {
            try {
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + String.valueOf(value) + "<-");
                Expression left = this.expression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + String.valueOf(value) + "<-");
                Expression right = this.expression(value);
                return this.ff.subtract(left, right);
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + String.valueOf(ife));
                return null;
            }
        }
        if (childName.equalsIgnoreCase("mul")) {
            try {
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + String.valueOf(value) + "<-");
                Expression left = this.expression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + String.valueOf(value) + "<-");
                Expression right = this.expression(value);
                return this.ff.multiply(left, right);
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + String.valueOf(ife));
                return null;
            }
        }
        if (childName.equalsIgnoreCase("div")) {
            try {
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add left value -> " + String.valueOf(value) + "<-");
                Expression left = this.expression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finer("add right value -> " + String.valueOf(value) + "<-");
                Expression right = this.expression(value);
                return this.ff.divide(left, right);
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression " + String.valueOf(ife));
                return null;
            }
        }
        if (childName.equalsIgnoreCase("PropertyName")) {
            try {
                String value = child.getFirstChild().getNodeValue();
                value = value != null ? value.trim() : value;
                PropertyName attribute = this.ff.property(value, ExpressionDOMParser.getNameSpaces(root));
                return attribute;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build expression: " + String.valueOf(ife));
                return null;
            }
        }
        if (childName.equalsIgnoreCase("Function")) {
            Element param = (Element)child;
            NamedNodeMap map = param.getAttributes();
            String funcName = null;
            for (int k = 0; k < map.getLength(); ++k) {
                String res = map.item(k).getNodeValue();
                String name = map.item(k).getLocalName();
                if (name == null) {
                    name = map.item(k).getNodeName();
                }
                if (name.indexOf(58) != -1) {
                    name = name.substring(name.indexOf(58) + 1);
                }
                LOGGER.fine("attribute " + name + " with value of " + res);
                if (!name.equalsIgnoreCase("name")) continue;
                funcName = res;
            }
            if (funcName == null) {
                LOGGER.severe("failed to find a function name in " + String.valueOf(child));
                return null;
            }
            ArrayList<Expression> args = new ArrayList<Expression>();
            block30: for (Node value = child.getFirstChild(); value != null; value = value.getNextSibling()) {
                while (value.getNodeType() != 1) {
                    if ((value = value.getNextSibling()) != null) continue;
                    break block30;
                }
                args.add(this.expression(value));
            }
            Expression[] array = args.toArray(new Expression[0]);
            return this.ff.function(funcName, array);
        }
        if (child.getNodeType() == 3) {
            LOGGER.finer("processing a text node " + root.getNodeValue());
            String nodeValue = root.getNodeValue();
            LOGGER.finer("Text name " + nodeValue);
            try {
                try {
                    Integer intLiteral = Integer.valueOf(nodeValue);
                    return this.ff.literal((Object)intLiteral);
                }
                catch (NumberFormatException intLiteral) {
                    try {
                        Double doubleLit = Double.valueOf(nodeValue);
                        return this.ff.literal((Object)doubleLit);
                    }
                    catch (NumberFormatException doubleLit) {
                        return this.ff.literal((Object)nodeValue);
                    }
                }
            }
            catch (IllegalFilterException ife) {
                LOGGER.finer("Unable to build expression " + String.valueOf(ife));
            }
        }
        return null;
    }

    public Geometry gml(Node root) {
        Node srsNameNode = root.getAttributes().getNamedItem("srsName");
        CoordinateReferenceSystem crs = null;
        if (srsNameNode != null) {
            String srs = srsNameNode.getTextContent();
            try {
                crs = CRS.decode((String)srs);
            }
            catch (Exception e) {
                LOGGER.warning("Failed to parse the specified SRS " + srs);
            }
        }
        Geometry g = this._gml(root);
        if (crs != null) {
            g.setUserData((Object)crs);
        }
        return g;
    }

    private Geometry _gml(Node root) {
        LOGGER.finer("processing gml " + String.valueOf(root));
        Node child = root;
        Object childName = child.getNodeName();
        if (childName == null) {
            childName = child.getLocalName();
        }
        if (!((String)childName).startsWith("gml:")) {
            childName = "gml:" + (String)childName;
        }
        if (((String)childName).equalsIgnoreCase("gml:box")) {
            List<Coordinate> coordList = new ExpressionDOMParser(CommonFactoryFinder.getFilterFactory2()).coords(child);
            Envelope env = new Envelope();
            for (Coordinate coordinate : coordList) {
                env.expandToInclude(coordinate);
            }
            Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
            LinearRing ring = null;
            try {
                ring = gfac.createLinearRing(coords);
            }
            catch (TopologyException tope) {
                LOGGER.fine("Topology Exception in GMLBox" + String.valueOf((Object)tope));
                return null;
            }
            return gfac.createPolygon(ring, null);
        }
        if (((String)childName).equalsIgnoreCase("gml:polygonmember") || ((String)childName).equalsIgnoreCase("gml:pointmember") || ((String)childName).equalsIgnoreCase("gml:linestringmember") || ((String)childName).equalsIgnoreCase("gml:linearringmember")) {
            for (int i = 0; i < child.getChildNodes().getLength(); ++i) {
                Node newChild = child.getChildNodes().item(i);
                if (newChild.getNodeType() != 1) continue;
                childName = newChild.getNodeName();
                if (!((String)childName).startsWith("gml:")) {
                    childName = "gml:" + (String)childName;
                }
                root = newChild;
                child = newChild;
                break;
            }
        }
        if (((String)childName).equalsIgnoreCase("gml:polygon")) {
            LOGGER.finer("polygon");
            LinearRing outer = null;
            ArrayList<LinearRing> inner = new ArrayList<LinearRing>();
            NodeList kids = root.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node kid = kids.item(i);
                LOGGER.finer("doing " + String.valueOf(kid));
                Object kidName = kid.getNodeName();
                if (kidName == null) {
                    kidName = child.getLocalName();
                }
                if (!((String)kidName).startsWith("gml:")) {
                    kidName = "gml:" + (String)kidName;
                }
                if (((String)kidName).equalsIgnoreCase("gml:outerBoundaryIs")) {
                    outer = (LinearRing)this.gml(kid);
                }
                if (!((String)kidName).equalsIgnoreCase("gml:innerBoundaryIs")) continue;
                inner.add((LinearRing)this.gml(kid));
            }
            if (inner.isEmpty()) {
                return gfac.createPolygon(outer, null);
            }
            return gfac.createPolygon(outer, inner.toArray(new LinearRing[0]));
        }
        if (((String)childName).equalsIgnoreCase("gml:outerBoundaryIs") || ((String)childName).equalsIgnoreCase("gml:innerBoundaryIs")) {
            LOGGER.finer("Boundary layer");
            NodeList kids = ((Element)child).getElementsByTagName("gml:LinearRing");
            if (kids.getLength() == 0) {
                kids = ((Element)child).getElementsByTagName("LinearRing");
            }
            return this.gml(kids.item(0));
        }
        if (((String)childName).equalsIgnoreCase("gml:linearRing")) {
            LOGGER.finer("LinearRing");
            List<Coordinate> coordList = new ExpressionDOMParser(CommonFactoryFinder.getFilterFactory2()).coords(child);
            LinearRing ring = null;
            try {
                ring = gfac.createLinearRing(coordList.toArray(new Coordinate[0]));
            }
            catch (TopologyException te) {
                LOGGER.finer("Topology Exception build linear ring: " + String.valueOf((Object)te));
                return null;
            }
            return ring;
        }
        if (((String)childName).equalsIgnoreCase("gml:linestring")) {
            LOGGER.finer("linestring");
            List<Coordinate> coordList = new ExpressionDOMParser(CommonFactoryFinder.getFilterFactory2()).coords(child);
            LineString line = gfac.createLineString(coordList.toArray(new Coordinate[0]));
            return line;
        }
        if (((String)childName).equalsIgnoreCase("gml:point")) {
            LOGGER.finer("point");
            List<Coordinate> coordList = new ExpressionDOMParser(CommonFactoryFinder.getFilterFactory2()).coords(child);
            Point point = gfac.createPoint(coordList.get(0));
            return point;
        }
        if (((String)childName).toLowerCase().startsWith("gml:multipolygon") || ((String)childName).toLowerCase().startsWith("gml:multilinestring") || ((String)childName).toLowerCase().startsWith("gml:multipoint")) {
            ArrayList<Geometry> multi = new ArrayList<Geometry>();
            NodeList kids = child.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                if (kids.item(i).getNodeType() != 1) continue;
                multi.add(this.gml(kids.item(i)));
            }
            if (((String)childName).toLowerCase().startsWith("gml:multipolygon")) {
                LOGGER.finer("MultiPolygon");
                return gfac.createMultiPolygon(multi.toArray(new Polygon[0]));
            }
            if (((String)childName).toLowerCase().startsWith("gml:multilinestring")) {
                LOGGER.finer("MultiLineString");
                return gfac.createMultiLineString(multi.toArray(new LineString[0]));
            }
            LOGGER.finer("MultiPoint");
            return gfac.createMultiPoint(multi.toArray(new Point[0]));
        }
        return null;
    }

    public List<Coordinate> coords(Node root) {
        LOGGER.finer("parsing coordinate(s) " + String.valueOf(root));
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>();
        NodeList kids = root.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node child = kids.item(i);
            LOGGER.finer("doing " + String.valueOf(child));
            Object childName = child.getNodeName();
            if (childName == null) {
                childName = child.getLocalName();
            }
            if (!((String)childName).startsWith("gml:")) {
                childName = "gml:" + (String)childName;
            }
            if (((String)childName).equalsIgnoreCase("gml:coord")) {
                Coordinate c = new Coordinate();
                NodeList grandChildren = child.getChildNodes();
                for (int t = 0; t < grandChildren.getLength(); ++t) {
                    Node grandChild = grandChildren.item(t);
                    Object grandChildName = grandChild.getNodeName();
                    if (grandChildName == null) {
                        grandChildName = grandChild.getLocalName();
                    }
                    if (!((String)grandChildName).startsWith("gml:")) {
                        grandChildName = "gml:" + (String)grandChildName;
                    }
                    if (((String)grandChildName).equalsIgnoreCase("gml:x")) {
                        c.x = Double.parseDouble(grandChild.getChildNodes().item(0).getNodeValue().trim());
                        continue;
                    }
                    if (((String)grandChildName).equalsIgnoreCase("gml:y")) {
                        c.y = Double.parseDouble(grandChild.getChildNodes().item(0).getNodeValue().trim());
                        continue;
                    }
                    if (!((String)grandChildName).equalsIgnoreCase("gml:z")) continue;
                    c.setZ(Double.parseDouble(grandChild.getChildNodes().item(0).getNodeValue().trim()));
                }
                clist.add(c);
            }
            if (!((String)childName).equalsIgnoreCase("gml:coordinates")) continue;
            LOGGER.finer("coordinates " + child.getFirstChild().getNodeValue());
            NodeList grandKids = child.getChildNodes();
            for (int k = 0; k < grandKids.getLength(); ++k) {
                Node grandKid = grandKids.item(k);
                if (grandKid.getNodeValue() == null || grandKid.getNodeValue().trim().length() == 0) continue;
                String outer = grandKid.getNodeValue().trim();
                StringTokenizer ost = new StringTokenizer(outer, " \n\t");
                while (ost.hasMoreTokens()) {
                    String internal = ost.nextToken();
                    StringTokenizer ist = new StringTokenizer(internal, ",");
                    double xCoord = Double.parseDouble(ist.nextToken());
                    double yCoord = Double.parseDouble(ist.nextToken());
                    double zCoord = Double.NaN;
                    if (ist.hasMoreTokens()) {
                        zCoord = Double.parseDouble(ist.nextToken());
                    }
                    clist.add(new Coordinate(xCoord, yCoord, zCoord));
                }
            }
        }
        return clist;
    }
}

